/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import sun.awt.geom.PathConsumer2D;

final class TransformingPathConsumer2D {
    private final Path2DWrapper wp_Path2DWrapper = new Path2DWrapper();
    private final TranslateFilter tx_TranslateFilter = new TranslateFilter();
    private final DeltaScaleFilter tx_DeltaScaleFilter = new DeltaScaleFilter();
    private final ScaleFilter tx_ScaleFilter = new ScaleFilter();
    private final DeltaTransformFilter tx_DeltaTransformFilter = new DeltaTransformFilter();
    private final TransformFilter tx_TransformFilter = new TransformFilter();
    private final DeltaScaleFilter dt_DeltaScaleFilter = new DeltaScaleFilter();
    private final DeltaTransformFilter dt_DeltaTransformFilter = new DeltaTransformFilter();
    private final DeltaScaleFilter iv_DeltaScaleFilter = new DeltaScaleFilter();
    private final DeltaTransformFilter iv_DeltaTransformFilter = new DeltaTransformFilter();

    TransformingPathConsumer2D() {
    }

    PathConsumer2D wrapPath2d(Path2D.Float float_) {
        return this.wp_Path2DWrapper.init(float_);
    }

    PathConsumer2D transformConsumer(PathConsumer2D pathConsumer2D, AffineTransform affineTransform) {
        if (affineTransform == null) {
            return pathConsumer2D;
        }
        float f = (float)affineTransform.getScaleX();
        float f2 = (float)affineTransform.getShearX();
        float f3 = (float)affineTransform.getTranslateX();
        float f4 = (float)affineTransform.getShearY();
        float f5 = (float)affineTransform.getScaleY();
        float f6 = (float)affineTransform.getTranslateY();
        if (f2 == 0.0f && f4 == 0.0f) {
            if (f == 1.0f && f5 == 1.0f) {
                if (f3 == 0.0f && f6 == 0.0f) {
                    return pathConsumer2D;
                }
                return this.tx_TranslateFilter.init(pathConsumer2D, f3, f6);
            }
            if (f3 == 0.0f && f6 == 0.0f) {
                return this.tx_DeltaScaleFilter.init(pathConsumer2D, f, f5);
            }
            return this.tx_ScaleFilter.init(pathConsumer2D, f, f5, f3, f6);
        }
        if (f3 == 0.0f && f6 == 0.0f) {
            return this.tx_DeltaTransformFilter.init(pathConsumer2D, f, f2, f4, f5);
        }
        return this.tx_TransformFilter.init(pathConsumer2D, f, f2, f3, f4, f5, f6);
    }

    PathConsumer2D deltaTransformConsumer(PathConsumer2D pathConsumer2D, AffineTransform affineTransform) {
        if (affineTransform == null) {
            return pathConsumer2D;
        }
        float f = (float)affineTransform.getScaleX();
        float f2 = (float)affineTransform.getShearX();
        float f3 = (float)affineTransform.getShearY();
        float f4 = (float)affineTransform.getScaleY();
        if (f2 == 0.0f && f3 == 0.0f) {
            if (f == 1.0f && f4 == 1.0f) {
                return pathConsumer2D;
            }
            return this.dt_DeltaScaleFilter.init(pathConsumer2D, f, f4);
        }
        return this.dt_DeltaTransformFilter.init(pathConsumer2D, f, f2, f3, f4);
    }

    PathConsumer2D inverseDeltaTransformConsumer(PathConsumer2D pathConsumer2D, AffineTransform affineTransform) {
        if (affineTransform == null) {
            return pathConsumer2D;
        }
        float f = (float)affineTransform.getScaleX();
        float f2 = (float)affineTransform.getShearX();
        float f3 = (float)affineTransform.getShearY();
        float f4 = (float)affineTransform.getScaleY();
        if (f2 == 0.0f && f3 == 0.0f) {
            if (f == 1.0f && f4 == 1.0f) {
                return pathConsumer2D;
            }
            return this.iv_DeltaScaleFilter.init(pathConsumer2D, 1.0f / f, 1.0f / f4);
        }
        float f5 = f * f4 - f2 * f3;
        return this.iv_DeltaTransformFilter.init(pathConsumer2D, f4 / f5, -f2 / f5, -f3 / f5, f / f5);
    }

    static final class DeltaScaleFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float sx;
        private float sy;

        DeltaScaleFilter() {
        }

        DeltaScaleFilter init(PathConsumer2D pathConsumer2D, float f, float f2) {
            this.out = pathConsumer2D;
            this.sx = f;
            this.sy = f2;
            return this;
        }

        @Override
        public void moveTo(float f, float f2) {
            this.out.moveTo(f * this.sx, f2 * this.sy);
        }

        @Override
        public void lineTo(float f, float f2) {
            this.out.lineTo(f * this.sx, f2 * this.sy);
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            this.out.quadTo(f * this.sx, f2 * this.sy, f3 * this.sx, f4 * this.sy);
        }

        @Override
        public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.out.curveTo(f * this.sx, f2 * this.sy, f3 * this.sx, f4 * this.sy, f5 * this.sx, f6 * this.sy);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }

    static final class DeltaTransformFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float mxx;
        private float mxy;
        private float myx;
        private float myy;

        DeltaTransformFilter() {
        }

        DeltaTransformFilter init(PathConsumer2D pathConsumer2D, float f, float f2, float f3, float f4) {
            this.out = pathConsumer2D;
            this.mxx = f;
            this.mxy = f2;
            this.myx = f3;
            this.myy = f4;
            return this;
        }

        @Override
        public void moveTo(float f, float f2) {
            this.out.moveTo(f * this.mxx + f2 * this.mxy, f * this.myx + f2 * this.myy);
        }

        @Override
        public void lineTo(float f, float f2) {
            this.out.lineTo(f * this.mxx + f2 * this.mxy, f * this.myx + f2 * this.myy);
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            this.out.quadTo(f * this.mxx + f2 * this.mxy, f * this.myx + f2 * this.myy, f3 * this.mxx + f4 * this.mxy, f3 * this.myx + f4 * this.myy);
        }

        @Override
        public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.out.curveTo(f * this.mxx + f2 * this.mxy, f * this.myx + f2 * this.myy, f3 * this.mxx + f4 * this.mxy, f3 * this.myx + f4 * this.myy, f5 * this.mxx + f6 * this.mxy, f5 * this.myx + f6 * this.myy);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }

    static final class Path2DWrapper
    implements PathConsumer2D {
        private Path2D.Float p2d;

        Path2DWrapper() {
        }

        Path2DWrapper init(Path2D.Float float_) {
            this.p2d = float_;
            return this;
        }

        @Override
        public void moveTo(float f, float f2) {
            this.p2d.moveTo(f, f2);
        }

        @Override
        public void lineTo(float f, float f2) {
            this.p2d.lineTo(f, f2);
        }

        @Override
        public void closePath() {
            this.p2d.closePath();
        }

        @Override
        public void pathDone() {
        }

        @Override
        public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.p2d.curveTo(f, f2, f3, f4, f5, f6);
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            this.p2d.quadTo(f, f2, f3, f4);
        }

        @Override
        public long getNativeConsumer() {
            throw new InternalError("Not using a native peer");
        }
    }

    static final class ScaleFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float sx;
        private float sy;
        private float tx;
        private float ty;

        ScaleFilter() {
        }

        ScaleFilter init(PathConsumer2D pathConsumer2D, float f, float f2, float f3, float f4) {
            this.out = pathConsumer2D;
            this.sx = f;
            this.sy = f2;
            this.tx = f3;
            this.ty = f4;
            return this;
        }

        @Override
        public void moveTo(float f, float f2) {
            this.out.moveTo(f * this.sx + this.tx, f2 * this.sy + this.ty);
        }

        @Override
        public void lineTo(float f, float f2) {
            this.out.lineTo(f * this.sx + this.tx, f2 * this.sy + this.ty);
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            this.out.quadTo(f * this.sx + this.tx, f2 * this.sy + this.ty, f3 * this.sx + this.tx, f4 * this.sy + this.ty);
        }

        @Override
        public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.out.curveTo(f * this.sx + this.tx, f2 * this.sy + this.ty, f3 * this.sx + this.tx, f4 * this.sy + this.ty, f5 * this.sx + this.tx, f6 * this.sy + this.ty);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }

    static final class TransformFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float mxx;
        private float mxy;
        private float mxt;
        private float myx;
        private float myy;
        private float myt;

        TransformFilter() {
        }

        TransformFilter init(PathConsumer2D pathConsumer2D, float f, float f2, float f3, float f4, float f5, float f6) {
            this.out = pathConsumer2D;
            this.mxx = f;
            this.mxy = f2;
            this.mxt = f3;
            this.myx = f4;
            this.myy = f5;
            this.myt = f6;
            return this;
        }

        @Override
        public void moveTo(float f, float f2) {
            this.out.moveTo(f * this.mxx + f2 * this.mxy + this.mxt, f * this.myx + f2 * this.myy + this.myt);
        }

        @Override
        public void lineTo(float f, float f2) {
            this.out.lineTo(f * this.mxx + f2 * this.mxy + this.mxt, f * this.myx + f2 * this.myy + this.myt);
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            this.out.quadTo(f * this.mxx + f2 * this.mxy + this.mxt, f * this.myx + f2 * this.myy + this.myt, f3 * this.mxx + f4 * this.mxy + this.mxt, f3 * this.myx + f4 * this.myy + this.myt);
        }

        @Override
        public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.out.curveTo(f * this.mxx + f2 * this.mxy + this.mxt, f * this.myx + f2 * this.myy + this.myt, f3 * this.mxx + f4 * this.mxy + this.mxt, f3 * this.myx + f4 * this.myy + this.myt, f5 * this.mxx + f6 * this.mxy + this.mxt, f5 * this.myx + f6 * this.myy + this.myt);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }

    static final class TranslateFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float tx;
        private float ty;

        TranslateFilter() {
        }

        TranslateFilter init(PathConsumer2D pathConsumer2D, float f, float f2) {
            this.out = pathConsumer2D;
            this.tx = f;
            this.ty = f2;
            return this;
        }

        @Override
        public void moveTo(float f, float f2) {
            this.out.moveTo(f + this.tx, f2 + this.ty);
        }

        @Override
        public void lineTo(float f, float f2) {
            this.out.lineTo(f + this.tx, f2 + this.ty);
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            this.out.quadTo(f + this.tx, f2 + this.ty, f3 + this.tx, f4 + this.ty);
        }

        @Override
        public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.out.curveTo(f + this.tx, f2 + this.ty, f3 + this.tx, f4 + this.ty, f5 + this.tx, f6 + this.ty);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }
}

