/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.util.stream.DoubleStream;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableDoubleBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableDoubleSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;

public class ImmutableDoubleBagFactoryImpl
implements ImmutableDoubleBagFactory {
    public static final ImmutableDoubleBagFactory INSTANCE = new ImmutableDoubleBagFactoryImpl();

    public ImmutableDoubleBag empty() {
        return ImmutableDoubleEmptyBag.INSTANCE;
    }

    public ImmutableDoubleBag of() {
        return this.empty();
    }

    public ImmutableDoubleBag with() {
        return this.empty();
    }

    public ImmutableDoubleBag of(double one) {
        return this.with(one);
    }

    public ImmutableDoubleBag with(double one) {
        return new ImmutableDoubleSingletonBag(one);
    }

    public ImmutableDoubleBag of(double ... items) {
        return this.with(items);
    }

    public ImmutableDoubleBag with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableDoubleHashBag.newBagWith(items);
    }

    public ImmutableDoubleBag ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public ImmutableDoubleBag withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleBag) {
            return (ImmutableDoubleBag)items;
        }
        if (items == null) {
            return this.with();
        }
        DoubleHashBag bag = new DoubleHashBag();
        items.forEach(arg_0 -> ((MutableDoubleBag)bag).add(arg_0));
        if (bag.size() == 0) {
            return this.with();
        }
        if (bag.size() == 1) {
            return this.with(bag.toArray());
        }
        return ImmutableDoubleHashBag.newBagWith(bag);
    }

    public ImmutableDoubleBag ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableDoubleBag withAll(Iterable<Double> iterable) {
        return DoubleBags.mutable.withAll(iterable).toImmutable();
    }

    public ImmutableDoubleBag ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    public ImmutableDoubleBag withAll(DoubleStream items) {
        if (items == null) {
            return this.with();
        }
        DoubleHashBag bag = new DoubleHashBag();
        items.forEach(arg_0 -> ((MutableDoubleBag)bag).add(arg_0));
        if (bag.size() == 0) {
            return this.with();
        }
        if (bag.size() == 1) {
            return this.with(bag.toArray());
        }
        return ImmutableDoubleHashBag.newBagWith(bag);
    }
}

