/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.api.tuple.primitive.CharObjectPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseCharIterable;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

final class ImmutableCharArrayList
implements ImmutableCharList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final char[] items;

    private ImmutableCharArrayList(char[] newElements) {
        if (newElements.length <= 1) {
            throw new IllegalArgumentException("Use CharLists.immutable.with() to instantiate an optimized collection");
        }
        this.items = newElements;
    }

    public static ImmutableCharArrayList newList(CharIterable iterable) {
        return new ImmutableCharArrayList(iterable.toArray());
    }

    public static ImmutableCharArrayList newListWith(char ... elements) {
        char[] newArray = new char[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableCharArrayList(newArray);
    }

    public char get(int index) {
        return this.items[index];
    }

    public char getFirst() {
        return this.items[0];
    }

    public char getLast() {
        return this.items[this.items.length - 1];
    }

    public int indexOf(char value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char value) {
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    public void each(CharProcedure procedure) {
        for (char item : this.items) {
            procedure.value(item);
        }
    }

    public void forEachWithIndex(CharIntProcedure procedure) {
        for (int i = 0; i < this.items.length; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    public int count(CharPredicate predicate) {
        int count = 0;
        for (char item : this.items) {
            if (!predicate.accept(item)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        for (char item : this.items) {
            if (!predicate.accept(item)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        for (char item : this.items) {
            if (predicate.accept(item)) continue;
            return false;
        }
        return true;
    }

    public ImmutableCharList select(CharPredicate predicate) {
        return this.select(predicate, new CharArrayList()).toImmutable();
    }

    public <R extends MutableCharCollection> R select(CharPredicate predicate, R target) {
        for (char item : this.items) {
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public ImmutableCharList reject(CharPredicate predicate) {
        return this.reject(predicate, new CharArrayList()).toImmutable();
    }

    public <R extends MutableCharCollection> R reject(CharPredicate predicate, R target) {
        for (char item : this.items) {
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        for (char item : this.items) {
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> ImmutableList<V> collect(CharToObjectFunction<? extends V> function) {
        MutableList list = this.collect(function, Lists.mutable.withInitialCapacity(this.items.length));
        return list.toImmutable();
    }

    public <V, R extends Collection<V>> R collect(CharToObjectFunction<? extends V> function, R target) {
        for (char item : this.items) {
            target.add((Object)function.valueOf(item));
        }
        return target;
    }

    public long sum() {
        long result = 0L;
        for (char item : this.items) {
            result += (long)item;
        }
        return result;
    }

    public char max() {
        char max = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            char value = this.items[i];
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public char maxIfEmpty(char defaultValue) {
        return this.max();
    }

    public char min() {
        char min = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            char value = this.items[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public char minIfEmpty(char defaultValue) {
        return this.min();
    }

    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public long dotProduct(CharList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum += (long)this.items[i] * (long)list.get(i);
        }
        return sum;
    }

    public LazyCharIterable asReversed() {
        return ReverseCharIterable.adapt((CharList)this);
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newList((CharIterable)this).sortThis();
    }

    public int binarySearch(char value) {
        return Arrays.binarySearch(this.items, value);
    }

    public char[] toArray() {
        char[] newItems = new char[this.items.length];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        return newItems;
    }

    public char[] toArray(char[] target) {
        if (target.length < this.items.length) {
            target = new char[this.items.length];
        }
        System.arraycopy(this.items, 0, target, 0, this.items.length);
        return target;
    }

    public boolean contains(char value) {
        for (char item : this.items) {
            if (item != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableCharList toImmutable() {
        return this;
    }

    public ImmutableCharArrayList toReversed() {
        return ImmutableCharArrayList.newList((CharIterable)this.asReversed());
    }

    public ImmutableCharList newWith(char element) {
        char[] newItems = new char[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        newItems[this.items.length] = element;
        return new ImmutableCharArrayList(newItems);
    }

    public ImmutableCharList newWithout(char element) {
        int index = this.indexOf(element);
        if (index != -1) {
            char[] newItems = new char[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
            return CharLists.immutable.with(newItems);
        }
        return this;
    }

    public ImmutableCharList newWithAll(CharIterable elements) {
        char[] newItems = new char[this.items.length + elements.size()];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        int index = 0;
        CharIterator iterator = elements.charIterator();
        while (iterator.hasNext()) {
            newItems[this.items.length + index] = iterator.next();
            ++index;
        }
        return new ImmutableCharArrayList(newItems);
    }

    public ImmutableCharList newWithoutAll(CharIterable elements) {
        MutableCharList mutableCharList = this.toList();
        mutableCharList.removeAll(elements);
        return mutableCharList.toImmutable();
    }

    public int size() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectCharIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)this);
            } else {
                CharIterator iterator = this.charIterator();
                while (iterator.hasNext()) {
                    MutableCharList batch = CharLists.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof CharList)) {
            return false;
        }
        CharList list = (CharList)otherList;
        if (this.items.length != list.size()) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (char item : this.items) {
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.items.length; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                char value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableCharList distinct() {
        CharHashSet seenSoFar = new CharHashSet(this.size());
        return this.select(arg_0 -> ((MutableCharSet)seenSoFar).add(arg_0));
    }

    public ImmutableCharList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    public ImmutableList<CharCharPair> zipChar(CharIterable iterable) {
        int size = this.size();
        int otherSize = iterable.size();
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, otherSize));
        CharIterator iterator = iterable.charIterator();
        for (int i = 0; i < size && iterator.hasNext(); ++i) {
            target.add((Object)PrimitiveTuples.pair(this.items[i], iterator.next()));
        }
        return target.toImmutable();
    }

    public <T> ImmutableList<CharObjectPair<T>> zip(Iterable<T> iterable) {
        int size = this.size();
        int otherSize = Iterate.sizeOf(iterable);
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, otherSize));
        Iterator<T> iterator = iterable.iterator();
        for (int i = 0; i < size && iterator.hasNext(); ++i) {
            target.add(PrimitiveTuples.pair(this.items[i], iterator.next()));
        }
        return target.toImmutable();
    }

    private class InternalCharIterator
    implements CharIterator {
        private int currentIndex;

        private InternalCharIterator() {
        }

        public boolean hasNext() {
            return this.currentIndex != ImmutableCharArrayList.this.items.length;
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char next = ImmutableCharArrayList.this.items[this.currentIndex];
            ++this.currentIndex;
            return next;
        }
    }
}

