/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableShortStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableShortStack;
import org.eclipse.collections.impl.factory.primitive.ShortStacks;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableShortArrayStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableShortEmptyStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableShortSingletonStack;

public class ImmutableShortStackFactoryImpl
implements ImmutableShortStackFactory {
    public static final ImmutableShortStackFactory INSTANCE = new ImmutableShortStackFactoryImpl();

    public ImmutableShortStack empty() {
        return ImmutableShortEmptyStack.INSTANCE;
    }

    public ImmutableShortStack of() {
        return this.empty();
    }

    public ImmutableShortStack with() {
        return this.empty();
    }

    public ImmutableShortStack of(short one) {
        return this.with(one);
    }

    public ImmutableShortStack with(short one) {
        return new ImmutableShortSingletonStack(one);
    }

    public ImmutableShortStack of(short ... items) {
        return this.with(items);
    }

    public ImmutableShortStack with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableShortArrayStack.newStackWith(items);
    }

    public ImmutableShortStack ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public ImmutableShortStack withAll(ShortIterable items) {
        if (items instanceof ImmutableShortStack) {
            return (ImmutableShortStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableShortStack ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableShortStack withAll(Iterable<Short> iterable) {
        return ShortStacks.mutable.withAll(iterable).toImmutable();
    }

    public ImmutableShortStack ofAllReversed(ShortIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableShortStack withAllReversed(ShortIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableShortArrayStack.newStackFromTopToBottom(items);
    }
}

