/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLOriginalLibrary;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLUsePackage;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;

public class XSLOverride
extends StyleElement {
    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.iterateAxis((byte)3).forEachOrFail(curr -> {
            if (curr.getNodeKind() == 3) {
                this.compileError("Character content is not allowed as a child of xsl:override", "XTSE0010");
            } else if (!(curr instanceof XSLFunction || curr instanceof XSLTemplate || curr instanceof XSLGlobalVariable || curr instanceof XSLAttributeSet)) {
                ((StyleElement)curr).compileError("Element " + curr.getDisplayName() + " is not allowed as a child of xsl:override", "XTSE0010");
            }
        });
    }

    @Override
    public void postValidate() throws XPathException {
        XSLUsePackage parent = (XSLUsePackage)this.getParent();
        assert (parent != null);
        if (parent.getUsedPackage() != null) {
            NodeInfo curr;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((curr = kids.next()) != null) {
                if (!(curr instanceof XSLFunction) && !(curr instanceof XSLTemplate) && !(curr instanceof XSLGlobalVariable) && !(curr instanceof XSLAttributeSet)) continue;
                StylesheetComponent procedure = (StylesheetComponent)((Object)curr);
                SymbolicName name = procedure.getSymbolicName();
                if (name == null) {
                    if (curr instanceof XSLTemplate) {
                        StructuredQName[] modeNames;
                        XSLTemplate decl = (XSLTemplate)curr;
                        if (decl.getMatch() == null) {
                            decl.compileError("An overriding template with no name must have a match pattern");
                        }
                        for (StructuredQName modeName : modeNames = decl.getModeNames()) {
                            if (modeName.equals(Mode.OMNI_MODE)) {
                                ((StyleElement)curr).compileError("An overriding template rule must not specify mode=\"#all\"", "XTSE3440");
                                continue;
                            }
                            if (!modeName.equals(Mode.UNNAMED_MODE_NAME) || !(modeName = decl.getDefaultMode()).equals(Mode.UNNAMED_MODE_NAME)) continue;
                            ((StyleElement)curr).compileError("An overriding template rule must not belong to the unnamed mode", "XTSE3440");
                        }
                        continue;
                    }
                    ((StyleElement)curr).compileError("An overriding component (other than a template rule) must have a name", "XTSE3440");
                    return;
                }
                Component overridden = parent.getUsedPackage().getComponent(name);
                if (overridden == null) {
                    ((StyleElement)curr).compileError("There is no " + StandardNames.getLocalName(name.getComponentKind()) + " named " + name.getShortName() + " in the used package", "XTSE3058");
                    return;
                }
                Visibility overriddenVis = overridden.getVisibility();
                if (overriddenVis == null) {
                    overriddenVis = Visibility.PRIVATE;
                }
                if (overriddenVis == Visibility.FINAL || overriddenVis == Visibility.PRIVATE) {
                    ((StyleElement)curr).compileError("The " + StandardNames.getLocalName(name.getComponentKind()) + " named " + name.getShortName() + " in the used package cannot be overridden because its visibility is " + (Object)((Object)overriddenVis), "XTSE3060");
                    return;
                }
                procedure.checkCompatibility(overridden);
            }
        }
    }

    public void addXSLOverrideFunctionLibrary(FunctionLibraryList list) {
        list.addFunctionLibrary(XSLOriginalLibrary.getInstance());
    }
}

