/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public abstract class LDAPSDKRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -805259180160427851L;

    protected LDAPSDKRuntimeException(@NotNull String message) {
        super(message);
    }

    protected LDAPSDKRuntimeException(@NotNull String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    @Override
    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append(super.toString());
    }

    @NotNull
    public String getExceptionMessage() {
        boolean includeCause = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages");
        boolean includeStackTrace = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages");
        return this.getExceptionMessage(includeCause, includeStackTrace);
    }

    @NotNull
    public String getExceptionMessage(boolean includeCause, boolean includeStackTrace) {
        Throwable cause;
        StringBuilder buffer = new StringBuilder();
        String message = this.getMessage();
        if (message == null || message.isEmpty()) {
            this.toString(buffer);
        } else {
            buffer.append(message);
        }
        if (includeStackTrace) {
            buffer.append(" stackTrace='");
            StaticUtils.getStackTrace(this, buffer);
        } else if (includeCause && (cause = this.getCause()) != null) {
            buffer.append(", cause=");
            buffer.append(StaticUtils.getExceptionMessage(cause));
        }
        String ldapSDKVersionString = ", ldapSDKVersion=6.0.0, revision=524c20f3bbcc0d83fb56b9e136a2fd3a7f60437d";
        if (buffer.indexOf(", ldapSDKVersion=6.0.0, revision=524c20f3bbcc0d83fb56b9e136a2fd3a7f60437d") < 0) {
            buffer.append(", ldapSDKVersion=6.0.0, revision=524c20f3bbcc0d83fb56b9e136a2fd3a7f60437d");
        }
        return buffer.toString();
    }
}

