/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBEKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;

abstract class PBEKeyFactory
extends SecretKeyFactorySpi {
    private String type;
    private static HashSet<String> validTypes = new HashSet(17);

    private PBEKeyFactory(String string) {
        this.type = string;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        return new PBEKey((PBEKeySpec)keySpec, this.type);
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class<?> clazz) throws InvalidKeySpecException {
        if (secretKey instanceof SecretKey && validTypes.contains(secretKey.getAlgorithm().toUpperCase(Locale.ENGLISH)) && secretKey.getFormat().equalsIgnoreCase("RAW")) {
            if (clazz != null && PBEKeySpec.class.isAssignableFrom(clazz)) {
                byte[] byArray = secretKey.getEncoded();
                char[] cArray = new char[byArray.length];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = (char)(byArray[i] & 0x7F);
                }
                PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
                Arrays.fill(cArray, ' ');
                Arrays.fill(byArray, (byte)0);
                return pBEKeySpec;
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        try {
            if (secretKey != null && validTypes.contains(secretKey.getAlgorithm().toUpperCase(Locale.ENGLISH)) && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (secretKey instanceof PBEKey) {
                    return secretKey;
                }
                PBEKeySpec pBEKeySpec = (PBEKeySpec)this.engineGetKeySpec(secretKey, PBEKeySpec.class);
                return this.engineGenerateSecret(pBEKeySpec);
            }
            throw new InvalidKeyException("Invalid key format/algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key: " + invalidKeySpecException.getMessage());
        }
    }

    static {
        validTypes.add("PBEWithMD5AndDES".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithSHA1AndDESede".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithSHA1AndRC2_40".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithSHA1AndRC2_128".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithSHA1AndRC4_40".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithSHA1AndRC4_128".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithMD5AndTripleDES".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA1AndAES_128".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA224AndAES_128".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA256AndAES_128".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA384AndAES_128".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA512AndAES_128".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA1AndAES_256".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA224AndAES_256".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA256AndAES_256".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA384AndAES_256".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSHA512AndAES_256".toUpperCase(Locale.ENGLISH));
    }

    public static final class PBEWithHmacSHA1AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA1AndAES_128() {
            super("PBEWithHmacSHA1AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA1AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA1AndAES_256() {
            super("PBEWithHmacSHA1AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA224AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA224AndAES_128() {
            super("PBEWithHmacSHA224AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA224AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA224AndAES_256() {
            super("PBEWithHmacSHA224AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA256AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA256AndAES_128() {
            super("PBEWithHmacSHA256AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA256AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA256AndAES_256() {
            super("PBEWithHmacSHA256AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA384AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA384AndAES_128() {
            super("PBEWithHmacSHA384AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA384AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA384AndAES_256() {
            super("PBEWithHmacSHA384AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA512AndAES_128
    extends PBEKeyFactory {
        public PBEWithHmacSHA512AndAES_128() {
            super("PBEWithHmacSHA512AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA512AndAES_256
    extends PBEKeyFactory {
        public PBEWithHmacSHA512AndAES_256() {
            super("PBEWithHmacSHA512AndAES_256");
        }
    }

    public static final class PBEWithMD5AndDES
    extends PBEKeyFactory {
        public PBEWithMD5AndDES() {
            super("PBEWithMD5AndDES");
        }
    }

    public static final class PBEWithMD5AndTripleDES
    extends PBEKeyFactory {
        public PBEWithMD5AndTripleDES() {
            super("PBEWithMD5AndTripleDES");
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends PBEKeyFactory {
        public PBEWithSHA1AndDESede() {
            super("PBEWithSHA1AndDESede");
        }
    }

    public static final class PBEWithSHA1AndRC2_128
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC2_128() {
            super("PBEWithSHA1AndRC2_128");
        }
    }

    public static final class PBEWithSHA1AndRC2_40
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC2_40() {
            super("PBEWithSHA1AndRC2_40");
        }
    }

    public static final class PBEWithSHA1AndRC4_128
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC4_128() {
            super("PBEWithSHA1AndRC4_128");
        }
    }

    public static final class PBEWithSHA1AndRC4_40
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC4_40() {
            super("PBEWithSHA1AndRC4_40");
        }
    }
}

