/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.TlsPrfGenerator;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

final class SslMacCore {
    private final MessageDigest md;
    private final byte[] pad1;
    private final byte[] pad2;
    private boolean first;
    private byte[] secret;

    SslMacCore(String string, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        this.md = MessageDigest.getInstance(string);
        this.pad1 = byArray;
        this.pad2 = byArray2;
        this.first = true;
    }

    int getDigestLength() {
        return this.md.getDigestLength();
    }

    void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("SslMac does not use parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        this.secret = key.getEncoded();
        if (this.secret == null || this.secret.length == 0) {
            throw new InvalidKeyException("Missing key data");
        }
        this.reset();
    }

    void update(byte by) {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
            this.first = false;
        }
        this.md.update(by);
    }

    void update(byte[] byArray, int n, int n2) {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
            this.first = false;
        }
        this.md.update(byArray, n, n2);
    }

    void update(ByteBuffer byteBuffer) {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
            this.first = false;
        }
        this.md.update(byteBuffer);
    }

    byte[] doFinal() {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
        } else {
            this.first = true;
        }
        try {
            byte[] byArray = this.md.digest();
            this.md.update(this.secret);
            this.md.update(this.pad2);
            this.md.update(byArray);
            this.md.digest(byArray, 0, byArray.length);
            return byArray;
        }
        catch (DigestException digestException) {
            throw new ProviderException(digestException);
        }
    }

    void reset() {
        if (!this.first) {
            this.md.reset();
            this.first = true;
        }
    }

    public static final class SslMacMD5
    extends MacSpi {
        private final SslMacCore core = new SslMacCore("MD5", md5Pad1, md5Pad2);
        static final byte[] md5Pad1 = TlsPrfGenerator.genPad((byte)54, 48);
        static final byte[] md5Pad2 = TlsPrfGenerator.genPad((byte)92, 48);

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, algorithmParameterSpec);
        }

        @Override
        protected void engineUpdate(byte by) {
            this.core.update(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.core.update(byArray, n, n2);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.core.update(byteBuffer);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }
    }

    public static final class SslMacSHA1
    extends MacSpi {
        private final SslMacCore core = new SslMacCore("SHA", shaPad1, shaPad2);
        static final byte[] shaPad1 = TlsPrfGenerator.genPad((byte)54, 40);
        static final byte[] shaPad2 = TlsPrfGenerator.genPad((byte)92, 40);

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, algorithmParameterSpec);
        }

        @Override
        protected void engineUpdate(byte by) {
            this.core.update(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.core.update(byArray, n, n2);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.core.update(byteBuffer);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }
    }
}

