/*
 * Decompiled with CFR 0.152.
 */
package org.cisecurity.db.fact;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cisecurity.db.impl.MSSQLDatabaseConnection;
import org.cisecurity.db.impl.MySQLDatabaseConnection;
import org.cisecurity.db.impl.OracleDatabaseConnection;
import org.cisecurity.db.impl.PostgreSQLDatabaseConnection;
import org.cisecurity.db.intf.IDatabaseConnection;
import org.cisecurity.db.util.DatabaseEngineEnumeration;
import org.cisecurity.session.fact.SessionConfig;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConnectionFactory
implements GroovyObject {
    private static Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DatabaseConnectionFactory() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DatabaseConnectionFactory.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static IDatabaseConnection getDatabaseConnection(String connectionString) {
        CallSite[] callSiteArray = DatabaseConnectionFactory.$getCallSiteArray();
        IDatabaseConnection conn = null;
        boolean bCheckForSysdba = false;
        callSiteArray[0].call((Object)logger, (Object)"DatabaseConnectionFactory::getDatabaseConnection --> START");
        Object flavor = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[1].callStatic(DatabaseConnectionFactory.class, (Object)connectionString);
            flavor = object;
        } else {
            DatabaseEngineEnumeration.ENUM eNUM;
            flavor = eNUM = DatabaseConnectionFactory.parseConnectionStringForFlavor(connectionString);
        }
        Object object = flavor;
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[2].callGetProperty(DatabaseEngineEnumeration.ENUM.class))) {
            boolean bl;
            Object object2 = callSiteArray[3].callConstructor(OracleDatabaseConnection.class);
            conn = (IDatabaseConnection)ScriptBytecodeAdapter.castToType((Object)object2, IDatabaseConnection.class);
            bCheckForSysdba = bl = true;
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[4].callGetProperty(DatabaseEngineEnumeration.ENUM.class))) {
            Object object3 = callSiteArray[5].callConstructor(MySQLDatabaseConnection.class);
            conn = (IDatabaseConnection)ScriptBytecodeAdapter.castToType((Object)object3, IDatabaseConnection.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[6].callGetProperty(DatabaseEngineEnumeration.ENUM.class))) {
            Object object4 = callSiteArray[7].callConstructor(MSSQLDatabaseConnection.class);
            conn = (IDatabaseConnection)ScriptBytecodeAdapter.castToType((Object)object4, IDatabaseConnection.class);
        } else if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[8].callGetProperty(DatabaseEngineEnumeration.ENUM.class))) {
            Object object5 = callSiteArray[9].callConstructor(PostgreSQLDatabaseConnection.class);
            conn = (IDatabaseConnection)ScriptBytecodeAdapter.castToType((Object)object5, IDatabaseConnection.class);
        } else {
            callSiteArray[10].call((Object)logger, (Object)"Unable to determine database connection type");
        }
        callSiteArray[11].call((Object)logger, (Object)"DatabaseConnectionFactory::getDatabaseConnection --> END");
        if (DefaultTypeTransformation.booleanUnbox((Object)conn)) {
            callSiteArray[12].call((Object)conn, (Object)connectionString);
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (bCheckForSysdba && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callStatic(DatabaseConnectionFactory.class, (Object)connectionString))) {
                    callSiteArray[14].call((Object)conn);
                } else {
                    callSiteArray[15].call((Object)logger, callSiteArray[16].call((Object)"Unable to determine database user privileges. isDatabaseConnectionUserSysdba came back as: ", callSiteArray[17].callStatic(DatabaseConnectionFactory.class, (Object)connectionString)));
                }
            } else if (bCheckForSysdba && DatabaseConnectionFactory.isDatabaseConnectionUserSysdba(connectionString)) {
                callSiteArray[18].call((Object)conn);
            } else {
                callSiteArray[19].call((Object)logger, callSiteArray[20].call((Object)"Unable to determine database user privileges. isDatabaseConnectionUserSysdba came back as: ", (Object)DatabaseConnectionFactory.isDatabaseConnectionUserSysdba(connectionString)));
            }
        }
        callSiteArray[21].call((Object)logger, (Object)"All database user privilege checks passed");
        return conn;
    }

    public static IDatabaseConnection getDatabaseConnection(SessionConfig config) {
        CallSite[] callSiteArray = DatabaseConnectionFactory.$getCallSiteArray();
        return (IDatabaseConnection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callStatic(DatabaseConnectionFactory.class, callSiteArray[23].callGroovyObjectGetProperty((Object)config), callSiteArray[24].callGroovyObjectGetProperty((Object)config)), IDatabaseConnection.class);
    }

    public static DatabaseEngineEnumeration.ENUM parseConnectionStringForFlavor(String connectionString) {
        CallSite[] callSiteArray = DatabaseConnectionFactory.$getCallSiteArray();
        String regex = "^jdbc(:jtds)?:(\\w+):.*$";
        callSiteArray[25].call((Object)logger, (Object)"DatabaseConnectionFactory::parseConnectionStringForFlavor -- [START]");
        Pattern pattern = (Pattern)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call(Pattern.class, (Object)regex), Pattern.class);
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call((Object)pattern, (Object)connectionString), Matcher.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call((Object)matcher))) {
            String matchingEngine = ShortTypeHandling.castToString((Object)callSiteArray[29].call((Object)matcher, (Object)2));
            callSiteArray[30].call((Object)logger, callSiteArray[31].call(callSiteArray[32].call((Object)"DatabaseConnectionFactory::parseConnectionStringForFlavor -- Found database engine string '", (Object)matchingEngine), (Object)"'..."));
            return (DatabaseEngineEnumeration.ENUM)ShortTypeHandling.castToEnum((Object)callSiteArray[33].call(DatabaseEngineEnumeration.ENUM.class, (Object)matchingEngine), DatabaseEngineEnumeration.ENUM.class);
        }
        callSiteArray[34].call((Object)logger, (Object)"DatabaseConnectionFactory::parseConnectionStringForFlavor -- Could not find matching database engine string...");
        return (DatabaseEngineEnumeration.ENUM)ShortTypeHandling.castToEnum(null, DatabaseEngineEnumeration.ENUM.class);
    }

    public static boolean isDatabaseConnectionUserSysdba(String connectionString) {
        CallSite[] callSiteArray = DatabaseConnectionFactory.$getCallSiteArray();
        callSiteArray[35].call((Object)logger, callSiteArray[36].call((Object)"DatabaseConnectionFactory::isDatabaseConnectionUserSysdba -- [START]", (Object)connectionString));
        Object r = ScriptBytecodeAdapter.bitwiseNegate((Object)"jdbc:oracle:thin:(.*)/.*");
        String SYS_1 = "sys";
        String SYS_2 = " as sysdba";
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].call(r, (Object)connectionString), Matcher.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].call((Object)matcher))) {
            String connectionUser = ShortTypeHandling.castToString((Object)callSiteArray[39].call(callSiteArray[40].call((Object)matcher, (Object)1)));
            callSiteArray[41].call((Object)logger, callSiteArray[42].call(callSiteArray[43].call((Object)"DatabaseConnectionFactory::isDatabaseConnectionUserSysdba -- Found database user string '", (Object)connectionUser), (Object)"'..."));
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].call((Object)connectionUser, (Object)SYS_1)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].call((Object)connectionUser, (Object)SYS_2));
        }
        callSiteArray[46].call((Object)logger, (Object)"DatabaseConnectionFactory::isDatabaseConnectionUserSysdba -- Could not find matching database user string...");
        return false;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DatabaseConnectionFactory.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = DatabaseConnectionFactory.$getCallSiteArray()[47].call(LoggerFactory.class, DatabaseConnectionFactory.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public static Logger getLogger() {
        return logger;
    }

    @Generated
    public static void setLogger(Logger logger) {
        DatabaseConnectionFactory.logger = logger;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "info";
        stringArray[1] = "parseConnectionStringForFlavor";
        stringArray[2] = "ORACLE";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "MYSQL";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "SQL_SERVER";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "POSTGRESQL";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "error";
        stringArray[11] = "info";
        stringArray[12] = "setConnectionString";
        stringArray[13] = "isDatabaseConnectionUserSysdba";
        stringArray[14] = "setConnectAsSysdba";
        stringArray[15] = "info";
        stringArray[16] = "plus";
        stringArray[17] = "isDatabaseConnectionUserSysdba";
        stringArray[18] = "setConnectAsSysdba";
        stringArray[19] = "info";
        stringArray[20] = "plus";
        stringArray[21] = "info";
        stringArray[22] = "getDatabaseConnection";
        stringArray[23] = "jdbcURL";
        stringArray[24] = "connectAsSysdba";
        stringArray[25] = "info";
        stringArray[26] = "compile";
        stringArray[27] = "matcher";
        stringArray[28] = "matches";
        stringArray[29] = "group";
        stringArray[30] = "info";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "typeOf";
        stringArray[34] = "info";
        stringArray[35] = "info";
        stringArray[36] = "plus";
        stringArray[37] = "matcher";
        stringArray[38] = "matches";
        stringArray[39] = "trim";
        stringArray[40] = "group";
        stringArray[41] = "info";
        stringArray[42] = "plus";
        stringArray[43] = "plus";
        stringArray[44] = "equalsIgnoreCase";
        stringArray[45] = "endsWith";
        stringArray[46] = "info";
        stringArray[47] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[48];
        DatabaseConnectionFactory.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DatabaseConnectionFactory.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DatabaseConnectionFactory.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

