/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLHandshakeException;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLMasterKeyDerivation;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;

final class KrbKeyExchange {
    static final SSLPossessionGenerator poGenerator = new KrbPossessionGenerator();
    static final SSLKeyAgreementGenerator kaGenerator = new KrbKAGenerator();

    KrbKeyExchange() {
    }

    private static final class KrbKAGenerator
    implements SSLKeyAgreementGenerator {
        private KrbKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            KrbPremasterSecret krbPremasterSecret = null;
            if (handshakeContext instanceof ClientHandshakeContext) {
                for (SSLPossession sSLPossession : handshakeContext.handshakePossessions) {
                    if (!(sSLPossession instanceof KrbPremasterSecret)) continue;
                    krbPremasterSecret = (KrbPremasterSecret)sSLPossession;
                    break;
                }
            } else {
                for (SSLCredentials sSLCredentials : handshakeContext.handshakeCredentials) {
                    if (!(sSLCredentials instanceof KrbPremasterSecret)) continue;
                    krbPremasterSecret = (KrbPremasterSecret)sSLCredentials;
                    break;
                }
            }
            if (krbPremasterSecret == null) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient KRB key agreement parameters negotiated");
            }
            return new KRBKAKeyDerivation(handshakeContext, krbPremasterSecret.preMaster);
        }

        private static final class KRBKAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final byte[] secretBytes;

            KRBKAKeyDerivation(HandshakeContext handshakeContext, byte[] byArray) {
                this.context = handshakeContext;
                this.secretBytes = byArray;
            }

            @Override
            public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
                try {
                    SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretBytes, "TlsPremasterSecret");
                    SSLMasterKeyDerivation sSLMasterKeyDerivation = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                    if (sSLMasterKeyDerivation == null) {
                        throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                    }
                    SSLKeyDerivation sSLKeyDerivation = sSLMasterKeyDerivation.createKeyDerivation(this.context, secretKeySpec);
                    return sSLKeyDerivation.deriveKey("MasterSecret", algorithmParameterSpec);
                }
                catch (Exception exception) {
                    throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(exception);
                }
            }
        }
    }

    static final class KrbPossessionGenerator
    implements SSLPossessionGenerator {
        KrbPossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            block8: {
                Object object = null;
                try {
                    String string;
                    final AccessControlContext accessControlContext = handshakeContext.conContext.acc;
                    object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return Krb5Helper.getServiceCreds(accessControlContext);
                        }
                    });
                    if (object == null) break block8;
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.fine("Using Kerberos creds", new Object[0]);
                    }
                    if ((string = Krb5Helper.getServerPrincipalName(object)) != null) {
                        SecurityManager securityManager = System.getSecurityManager();
                        try {
                            if (securityManager != null) {
                                securityManager.checkPermission(Krb5Helper.getServicePermission(string, "accept"), accessControlContext);
                            }
                        }
                        catch (SecurityException securityException) {
                            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                                SSLLogger.fine("Permission to access Kerberos secret key denied", new Object[0]);
                            }
                            return null;
                        }
                    }
                    return new KrbServiceCreds(object);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block8;
                    SSLLogger.fine("Attempt to obtain Kerberos key failed: " + privilegedActionException.toString(), new Object[0]);
                }
            }
            return null;
        }
    }

    static final class KrbPremasterSecret
    implements SSLPossession,
    SSLCredentials {
        final byte[] preMaster;

        KrbPremasterSecret(byte[] byArray) {
            this.preMaster = byArray;
        }

        static KrbPremasterSecret createPremasterSecret(ProtocolVersion protocolVersion, SecureRandom secureRandom) {
            byte[] byArray = new byte[48];
            secureRandom.nextBytes(byArray);
            byArray[0] = protocolVersion.major;
            byArray[1] = protocolVersion.minor;
            return new KrbPremasterSecret(byArray);
        }

        static KrbPremasterSecret decode(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, byte[] byArray, SecureRandom secureRandom) {
            KrbPremasterSecret krbPremasterSecret = null;
            boolean bl = true;
            ProtocolVersion protocolVersion3 = null;
            if (byArray != null && byArray.length == 48) {
                protocolVersion3 = ProtocolVersion.valueOf(byArray[0], byArray[1]);
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Kerberos pre-master secret protocol version: " + (Object)((Object)protocolVersion3), new Object[0]);
                }
                boolean bl2 = bl = protocolVersion3.compare(protocolVersion2) != 0;
                if (bl && protocolVersion2.compare(ProtocolVersion.TLS10) <= 0) {
                    boolean bl3 = bl = protocolVersion3.compare(protocolVersion) != 0;
                }
            }
            if (bl) {
                krbPremasterSecret = KrbPremasterSecret.createPremasterSecret(protocolVersion2, secureRandom);
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Kerberos pre-master secret error, generating random secret for safe failure.", new Object[0]);
                }
            } else {
                krbPremasterSecret = new KrbPremasterSecret(byArray);
            }
            return krbPremasterSecret;
        }
    }

    static final class KrbServiceCreds
    implements SSLPossession {
        final Object serviceCreds;

        KrbServiceCreds(Object object) {
            this.serviceCreds = object;
        }
    }
}

