/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.provider.certpath.ResponderId;
import sun.security.ssl.CertStatusExtension;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.X509Authentication;
import sun.security.util.Cache;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SerialNumber;

final class StatusResponseManager {
    private static final int DEFAULT_CORE_THREADS = 8;
    private static final int DEFAULT_CACHE_SIZE = 256;
    private static final int DEFAULT_CACHE_LIFETIME = 3600;
    private final ScheduledThreadPoolExecutor threadMgr;
    private final Cache<CertId, ResponseCacheEntry> responseCache;
    private final URI defaultResponder;
    private final boolean respOverride;
    private final int cacheCapacity;
    private final int cacheLifetime;
    private final boolean ignoreExtensions;

    StatusResponseManager() {
        URI uRI;
        int n = AccessController.doPrivileged(new GetIntegerAction("jdk.tls.stapling.cacheSize", 256));
        this.cacheCapacity = n > 0 ? n : 0;
        int n2 = AccessController.doPrivileged(new GetIntegerAction("jdk.tls.stapling.cacheLifetime", 3600));
        this.cacheLifetime = n2 > 0 ? n2 : 0;
        String string = GetPropertyAction.privilegedGetProperty("jdk.tls.stapling.responderURI");
        try {
            uRI = string != null && !string.isEmpty() ? new URI(string) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI = null;
        }
        this.defaultResponder = uRI;
        this.respOverride = AccessController.doPrivileged(new GetBooleanAction("jdk.tls.stapling.responderOverride"));
        this.ignoreExtensions = AccessController.doPrivileged(new GetBooleanAction("jdk.tls.stapling.ignoreExtensions"));
        this.threadMgr = new ScheduledThreadPoolExecutor(8, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        }, new ThreadPoolExecutor.DiscardPolicy());
        this.threadMgr.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.threadMgr.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.threadMgr.setKeepAliveTime(5000L, TimeUnit.MILLISECONDS);
        this.threadMgr.allowCoreThreadTimeOut(true);
        this.responseCache = Cache.newSoftMemoryCache(this.cacheCapacity, this.cacheLifetime);
    }

    int getCacheLifetime() {
        return this.cacheLifetime;
    }

    int getCacheCapacity() {
        return this.cacheCapacity;
    }

    URI getDefaultResponder() {
        return this.defaultResponder;
    }

    boolean getURIOverride() {
        return this.respOverride;
    }

    boolean getIgnoreExtensions() {
        return this.ignoreExtensions;
    }

    void clear() {
        if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
            SSLLogger.fine("Clearing response cache", new Object[0]);
        }
        this.responseCache.clear();
    }

    int size() {
        return this.responseCache.size();
    }

    URI getURI(X509Certificate x509Certificate) {
        Objects.requireNonNull(x509Certificate);
        if (x509Certificate.getExtensionValue(PKIXExtensions.OCSPNoCheck_Id.toString()) != null) {
            if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                SSLLogger.fine("OCSP NoCheck extension found.  OCSP will be skipped", new Object[0]);
            }
            return null;
        }
        if (this.defaultResponder != null && this.respOverride) {
            if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                SSLLogger.fine("Responder override: URI is " + this.defaultResponder, new Object[0]);
            }
            return this.defaultResponder;
        }
        URI uRI = OCSP.getResponderURI(x509Certificate);
        return uRI != null ? uRI : this.defaultResponder;
    }

    void shutdown() {
        if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
            SSLLogger.fine("Shutting down " + this.threadMgr.getActiveCount() + " active threads", new Object[0]);
        }
        this.threadMgr.shutdown();
    }

    Map<X509Certificate, byte[]> get(CertStatusExtension.CertStatusRequestType certStatusRequestType, CertStatusExtension.CertStatusRequest certStatusRequest, X509Certificate[] x509CertificateArray, long l, TimeUnit timeUnit) {
        HashMap<X509Certificate, byte[]> hashMap;
        block21: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ArrayList<OCSPFetchCall> arrayList;
            block20: {
                hashMap = new HashMap<X509Certificate, byte[]>();
                arrayList = new ArrayList<OCSPFetchCall>();
                if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                    SSLLogger.fine("Beginning check: Type = " + (Object)((Object)certStatusRequestType) + ", Chain length = " + x509CertificateArray.length, new Object[0]);
                }
                if (x509CertificateArray.length < 2) {
                    return Collections.emptyMap();
                }
                if (certStatusRequestType == CertStatusExtension.CertStatusRequestType.OCSP) {
                    try {
                        object4 = (CertStatusExtension.OCSPStatusRequest)certStatusRequest;
                        object3 = new CertId(x509CertificateArray[1], new SerialNumber(x509CertificateArray[0].getSerialNumber()));
                        object2 = this.getFromCache((CertId)object3, (CertStatusExtension.OCSPStatusRequest)object4);
                        if (object2 != null) {
                            hashMap.put(x509CertificateArray[0], ((ResponseCacheEntry)object2).ocspBytes);
                            break block20;
                        }
                        object = new StatusInfo(x509CertificateArray[0], (CertId)object3);
                        arrayList.add(new OCSPFetchCall((StatusInfo)object, (CertStatusExtension.OCSPStatusRequest)object4));
                    }
                    catch (IOException iOException) {
                        if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                            SSLLogger.fine("Exception during CertId creation: ", iOException);
                        }
                        break block20;
                    }
                }
                if (certStatusRequestType == CertStatusExtension.CertStatusRequestType.OCSP_MULTI) {
                    object4 = (CertStatusExtension.OCSPStatusRequest)certStatusRequest;
                    for (int i = 0; i < x509CertificateArray.length - 1; ++i) {
                        try {
                            object2 = new CertId(x509CertificateArray[i + 1], new SerialNumber(x509CertificateArray[i].getSerialNumber()));
                            object = this.getFromCache((CertId)object2, (CertStatusExtension.OCSPStatusRequest)object4);
                            if (object != null) {
                                hashMap.put(x509CertificateArray[i], ((ResponseCacheEntry)object).ocspBytes);
                                continue;
                            }
                            StatusInfo statusInfo = new StatusInfo(x509CertificateArray[i], (CertId)object2);
                            arrayList.add(new OCSPFetchCall(statusInfo, (CertStatusExtension.OCSPStatusRequest)object4));
                            continue;
                        }
                        catch (IOException iOException) {
                            if (!SSLLogger.isOn || !SSLLogger.isOn("respmgr")) continue;
                            SSLLogger.fine("Exception during CertId creation: ", iOException);
                        }
                    }
                } else if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                    SSLLogger.fine("Unsupported status request type: " + (Object)((Object)certStatusRequestType), new Object[0]);
                }
            }
            if (!arrayList.isEmpty()) {
                try {
                    object4 = this.threadMgr.invokeAll(arrayList, l, timeUnit);
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (Future)object3.next();
                        if (!object2.isDone()) continue;
                        if (!object2.isCancelled()) {
                            object = (StatusInfo)object2.get();
                            if (object != null && ((StatusInfo)object).responseData != null) {
                                hashMap.put(((StatusInfo)object).cert, ((StatusInfo)object).responseData.ocspBytes);
                                continue;
                            }
                            if (!SSLLogger.isOn || !SSLLogger.isOn("respmgr")) continue;
                            SSLLogger.fine("Completed task had no response data", new Object[0]);
                            continue;
                        }
                        if (!SSLLogger.isOn || !SSLLogger.isOn("respmgr")) continue;
                        SSLLogger.fine("Found cancelled task", new Object[0]);
                    }
                }
                catch (InterruptedException | ExecutionException exception) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("respmgr")) break block21;
                    SSLLogger.fine("Exception when getting data: ", exception);
                }
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private ResponseCacheEntry getFromCache(CertId certId, CertStatusExtension.OCSPStatusRequest oCSPStatusRequest) {
        for (Extension extension : oCSPStatusRequest.extensions) {
            if (!extension.getId().equals(PKIXExtensions.OCSPNonce_Id.toString())) continue;
            if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                SSLLogger.fine("Nonce extension found, skipping cache check", new Object[0]);
            }
            return null;
        }
        Object object = this.responseCache.get(certId);
        if (object != null && ((ResponseCacheEntry)object).nextUpdate != null && ((ResponseCacheEntry)object).nextUpdate.before(new Date())) {
            if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                SSLLogger.fine("nextUpdate threshold exceeded, purging from cache", new Object[0]);
            }
            object = null;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
            SSLLogger.fine("Check cache for SN" + certId.getSerialNumber() + ": " + (object != null ? "HIT" : "MISS"), new Object[0]);
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("StatusResponseManager: ");
        stringBuilder.append("Core threads: ").append(this.threadMgr.getCorePoolSize());
        stringBuilder.append(", Cache timeout: ");
        if (this.cacheLifetime > 0) {
            stringBuilder.append(this.cacheLifetime).append(" seconds");
        } else {
            stringBuilder.append(" indefinite");
        }
        stringBuilder.append(", Cache MaxSize: ");
        if (this.cacheCapacity > 0) {
            stringBuilder.append(this.cacheCapacity).append(" items");
        } else {
            stringBuilder.append(" unbounded");
        }
        stringBuilder.append(", Default URI: ");
        if (this.defaultResponder != null) {
            stringBuilder.append(this.defaultResponder);
        } else {
            stringBuilder.append("NONE");
        }
        return stringBuilder.toString();
    }

    static final StaplingParameters processStapling(ServerHandshakeContext serverHandshakeContext) {
        Object object;
        Object object22;
        StaplingParameters staplingParameters = null;
        SSLExtension sSLExtension = null;
        CertStatusExtension.CertStatusRequestType certStatusRequestType = null;
        CertStatusExtension.CertStatusRequest certStatusRequest = null;
        if (!serverHandshakeContext.sslContext.isStaplingEnabled(false) || serverHandshakeContext.isResumption) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Staping disabled or is a resumed session", new Object[0]);
            }
            return null;
        }
        Map map = serverHandshakeContext.handshakeExtensions;
        CertStatusExtension.CertStatusRequestSpec certStatusRequestSpec = (CertStatusExtension.CertStatusRequestSpec)map.get(SSLExtension.CH_STATUS_REQUEST);
        CertStatusExtension.CertStatusRequestV2Spec certStatusRequestV2Spec = (CertStatusExtension.CertStatusRequestV2Spec)map.get(SSLExtension.CH_STATUS_REQUEST_V2);
        if (certStatusRequestV2Spec != null && !serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                SSLLogger.fine("SH Processing status_request_v2 extension", new Object[0]);
            }
            sSLExtension = SSLExtension.CH_STATUS_REQUEST_V2;
            int n = -1;
            int n2 = -1;
            object22 = certStatusRequestV2Spec.certStatusRequests;
            for (int i = 0; i < ((CertStatusExtension.CertStatusRequest[])object22).length && (n == -1 || n2 == -1); ++i) {
                CertStatusExtension.OCSPStatusRequest oCSPStatusRequest;
                object = object22[i];
                CertStatusExtension.CertStatusRequestType certStatusRequestType2 = CertStatusExtension.CertStatusRequestType.valueOf(((CertStatusExtension.CertStatusRequest)object).statusType);
                if (n < 0 && certStatusRequestType2 == CertStatusExtension.CertStatusRequestType.OCSP) {
                    oCSPStatusRequest = (CertStatusExtension.OCSPStatusRequest)object;
                    if (!oCSPStatusRequest.responderIds.isEmpty()) continue;
                    n = i;
                    continue;
                }
                if (n2 >= 0 || certStatusRequestType2 != CertStatusExtension.CertStatusRequestType.OCSP_MULTI) continue;
                oCSPStatusRequest = (CertStatusExtension.OCSPStatusRequest)object;
                if (!oCSPStatusRequest.responderIds.isEmpty()) continue;
                n2 = i;
            }
            if (n2 >= 0) {
                certStatusRequest = object22[n2];
                certStatusRequestType = CertStatusExtension.CertStatusRequestType.valueOf(certStatusRequest.statusType);
            } else if (n >= 0) {
                certStatusRequest = object22[n];
                certStatusRequestType = CertStatusExtension.CertStatusRequestType.valueOf(certStatusRequest.statusType);
            } else if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.finest("Warning: No suitable request found in the status_request_v2 extension.", new Object[0]);
            }
        }
        if (certStatusRequestSpec != null && (sSLExtension == null || certStatusRequestType == null || certStatusRequest == null)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake,verbose")) {
                SSLLogger.fine("SH Processing status_request extension", new Object[0]);
            }
            sSLExtension = SSLExtension.CH_STATUS_REQUEST;
            certStatusRequestType = CertStatusExtension.CertStatusRequestType.valueOf(certStatusRequestSpec.statusRequest.statusType);
            if (certStatusRequestType == CertStatusExtension.CertStatusRequestType.OCSP) {
                CertStatusExtension.OCSPStatusRequest oCSPStatusRequest = (CertStatusExtension.OCSPStatusRequest)certStatusRequestSpec.statusRequest;
                if (oCSPStatusRequest.responderIds.isEmpty()) {
                    certStatusRequest = oCSPStatusRequest;
                } else if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Warning: No suitable request found in the status_request extension.", new Object[0]);
                }
            }
        }
        if (certStatusRequestType == null || certStatusRequest == null || sSLExtension == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("No suitable status_request or status_request_v2, stapling is disabled", new Object[0]);
            }
            return null;
        }
        X509Authentication.X509Possession x509Possession = null;
        for (Object object22 : serverHandshakeContext.handshakePossessions) {
            if (!(object22 instanceof X509Authentication.X509Possession)) continue;
            x509Possession = (X509Authentication.X509Possession)object22;
            break;
        }
        if (x509Possession == null) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.finest("Warning: no X.509 certificates found.  Stapling is disabled.", new Object[0]);
            }
            return null;
        }
        X509Certificate[] x509CertificateArray = x509Possession.popCerts;
        object22 = serverHandshakeContext.sslContext.getStatusResponseManager();
        if (object22 != null) {
            CertStatusExtension.CertStatusRequestType certStatusRequestType3 = serverHandshakeContext.negotiatedProtocol.useTLS13PlusSpec() ? CertStatusExtension.CertStatusRequestType.OCSP_MULTI : certStatusRequestType;
            Map<X509Certificate, byte[]> map2 = ((StatusResponseManager)object22).get(certStatusRequestType3, certStatusRequest, x509CertificateArray, serverHandshakeContext.statusRespTimeout, TimeUnit.MILLISECONDS);
            if (!map2.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Response manager returned " + map2.size() + " entries.", new Object[0]);
                }
                if (certStatusRequestType == CertStatusExtension.CertStatusRequestType.OCSP && ((object = (Object)map2.get(x509CertificateArray[0])) == null || ((Object)object).length <= 0)) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                        SSLLogger.finest("Warning: Null or zero-length response found for leaf certificate. Stapling is disabled.", new Object[0]);
                    }
                    return null;
                }
                staplingParameters = new StaplingParameters(sSLExtension, certStatusRequestType, certStatusRequest, map2);
            } else if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.finest("Warning: no OCSP responses obtained.  Stapling is disabled.", new Object[0]);
            }
        } else {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.finest("Warning: lazy initialization of the StatusResponseManager failed.  Stapling is disabled.", new Object[0]);
            }
            staplingParameters = null;
        }
        return staplingParameters;
    }

    class OCSPFetchCall
    implements Callable<StatusInfo> {
        StatusInfo statInfo;
        CertStatusExtension.OCSPStatusRequest ocspRequest;
        List<Extension> extensions;
        List<ResponderId> responderIds;

        public OCSPFetchCall(StatusInfo statusInfo, CertStatusExtension.OCSPStatusRequest oCSPStatusRequest) {
            this.statInfo = Objects.requireNonNull(statusInfo, "Null StatusInfo not allowed");
            this.ocspRequest = Objects.requireNonNull(oCSPStatusRequest, "Null OCSPStatusRequest not allowed");
            this.extensions = this.ocspRequest.extensions;
            this.responderIds = this.ocspRequest.responderIds;
        }

        @Override
        public StatusInfo call() {
            block11: {
                if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                    SSLLogger.fine("Starting fetch for SN " + this.statInfo.cid.getSerialNumber(), new Object[0]);
                }
                try {
                    if (this.statInfo.responder == null) {
                        if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                            SSLLogger.fine("Null URI detected, OCSP fetch aborted", new Object[0]);
                        }
                        return this.statInfo;
                    }
                    if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                        SSLLogger.fine("Attempting fetch from " + this.statInfo.responder, new Object[0]);
                    }
                    List<Extension> list = StatusResponseManager.this.ignoreExtensions || !this.responderIds.isEmpty() ? Collections.emptyList() : this.extensions;
                    byte[] byArray = OCSP.getOCSPBytes(Collections.singletonList(this.statInfo.cid), this.statInfo.responder, list);
                    if (byArray != null) {
                        ResponseCacheEntry responseCacheEntry = new ResponseCacheEntry(byArray, this.statInfo.cid);
                        if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                            SSLLogger.fine("OCSP Status: " + (Object)((Object)responseCacheEntry.status) + " (" + byArray.length + " bytes)", new Object[0]);
                        }
                        if (responseCacheEntry.status == OCSPResponse.ResponseStatus.SUCCESSFUL) {
                            this.statInfo.responseData = responseCacheEntry;
                            this.addToCache(this.statInfo.cid, responseCacheEntry);
                        }
                    } else if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                        SSLLogger.fine("No data returned from OCSP Responder", new Object[0]);
                    }
                }
                catch (IOException iOException) {
                    if (!SSLLogger.isOn || !SSLLogger.isOn("respmgr")) break block11;
                    SSLLogger.fine("Caught exception: ", iOException);
                }
            }
            return this.statInfo;
        }

        private void addToCache(CertId certId, ResponseCacheEntry responseCacheEntry) {
            if (responseCacheEntry.nextUpdate == null && StatusResponseManager.this.cacheLifetime == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                    SSLLogger.fine("Not caching this OCSP response", new Object[0]);
                }
            } else {
                StatusResponseManager.this.responseCache.put(certId, responseCacheEntry);
                if (SSLLogger.isOn && SSLLogger.isOn("respmgr")) {
                    SSLLogger.fine("Added response for SN " + certId.getSerialNumber() + " to cache", new Object[0]);
                }
            }
        }

        private long getNextTaskDelay(Date date) {
            long l;
            int n = StatusResponseManager.this.getCacheLifetime();
            if (date != null) {
                long l2 = (date.getTime() - System.currentTimeMillis()) / 1000L;
                l = n > 0 ? Long.min(l2, n) : l2;
            } else {
                l = n > 0 ? (long)n : -1L;
            }
            return l;
        }
    }

    class ResponseCacheEntry {
        final OCSPResponse.ResponseStatus status;
        final byte[] ocspBytes;
        final Date nextUpdate;
        final OCSPResponse.SingleResponse singleResp;
        final ResponderId respId;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ResponseCacheEntry(byte[] byArray, CertId certId) throws IOException {
            Objects.requireNonNull(byArray, "Non-null responseBytes required");
            Objects.requireNonNull(certId, "Non-null Cert ID required");
            this.ocspBytes = (byte[])byArray.clone();
            OCSPResponse oCSPResponse = new OCSPResponse(this.ocspBytes);
            this.status = oCSPResponse.getResponseStatus();
            this.respId = oCSPResponse.getResponderId();
            this.singleResp = oCSPResponse.getSingleResponse(certId);
            if (this.status == OCSPResponse.ResponseStatus.SUCCESSFUL) {
                if (this.singleResp == null) throw new IOException("Unable to find SingleResponse for SN " + certId.getSerialNumber());
                this.nextUpdate = this.singleResp.getNextUpdate();
                return;
            } else {
                this.nextUpdate = null;
            }
        }
    }

    static final class StaplingParameters {
        final SSLExtension statusRespExt;
        final CertStatusExtension.CertStatusRequestType statReqType;
        final CertStatusExtension.CertStatusRequest statReqData;
        final Map<X509Certificate, byte[]> responseMap;

        StaplingParameters(SSLExtension sSLExtension, CertStatusExtension.CertStatusRequestType certStatusRequestType, CertStatusExtension.CertStatusRequest certStatusRequest, Map<X509Certificate, byte[]> map) {
            this.statusRespExt = sSLExtension;
            this.statReqType = certStatusRequestType;
            this.statReqData = certStatusRequest;
            this.responseMap = map;
        }
    }

    class StatusInfo {
        final X509Certificate cert;
        final CertId cid;
        final URI responder;
        ResponseCacheEntry responseData;

        StatusInfo(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws IOException {
            this(x509Certificate, new CertId(x509Certificate2, new SerialNumber(x509Certificate.getSerialNumber())));
        }

        StatusInfo(X509Certificate x509Certificate, CertId certId) {
            this.cert = x509Certificate;
            this.cid = certId;
            this.responder = StatusResponseManager.this.getURI(this.cert);
            this.responseData = null;
        }

        StatusInfo(StatusInfo statusInfo) {
            this.cert = statusInfo.cert;
            this.cid = statusInfo.cid;
            this.responder = statusInfo.responder;
            this.responseData = null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("StatusInfo:");
            stringBuilder.append("\n\tCert: ").append(this.cert.getSubjectX500Principal());
            stringBuilder.append("\n\tSerial: ").append(this.cert.getSerialNumber());
            stringBuilder.append("\n\tResponder: ").append(this.responder);
            stringBuilder.append("\n\tResponse data: ").append(this.responseData != null ? this.responseData.ocspBytes.length + " bytes" : "<NULL>");
            return stringBuilder.toString();
        }
    }
}

