/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.DHKeyExchange;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.RSASignature;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;
import sun.security.util.KeyUtil;

final class DHServerKeyExchange {
    static final SSLConsumer dhHandshakeConsumer = new DHServerKeyExchangeConsumer();
    static final HandshakeProducer dhHandshakeProducer = new DHServerKeyExchangeProducer();

    DHServerKeyExchange() {
    }

    static final class DHServerKeyExchangeConsumer
    implements SSLConsumer {
        private DHServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            DHPublicKey dHPublicKey;
            Object object;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            DHServerKeyExchangeMessage dHServerKeyExchangeMessage = new DHServerKeyExchangeMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming DH ServerKeyExchange handshake message", dHServerKeyExchangeMessage);
            }
            try {
                object = JsseJce.getKeyFactory("DiffieHellman");
                DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(new BigInteger(1, dHServerKeyExchangeMessage.y), new BigInteger(1, dHServerKeyExchangeMessage.p), new BigInteger(1, dHServerKeyExchangeMessage.g));
                dHPublicKey = (DHPublicKey)object.generatePublic(dHPublicKeySpec);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "Could not generate DHPublicKey", generalSecurityException);
            }
            if (!clientHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), dHPublicKey)) {
                throw clientHandshakeContext.conContext.fatal(Alert.INSUFFICIENT_SECURITY, "DH ServerKeyExchange does not comply to algorithm constraints");
            }
            object = SupportedGroupsExtension.NamedGroup.valueOf(dHPublicKey.getParams());
            clientHandshakeContext.handshakeCredentials.add(new DHKeyExchange.DHECredentials(dHPublicKey, (SupportedGroupsExtension.NamedGroup)((Object)object)));
        }
    }

    private static final class DHServerKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] p;
        private final byte[] g;
        private final byte[] y;
        private final boolean useExplicitSigAlgorithm;
        private final SignatureScheme signatureScheme;
        private final byte[] paramsSignature;

        DHServerKeyExchangeMessage(HandshakeContext handshakeContext) throws IOException {
            super(handshakeContext);
            Object object2;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            DHKeyExchange.DHEPossession dHEPossession = null;
            X509Authentication.X509Possession x509Possession = null;
            for (Object object2 : serverHandshakeContext.handshakePossessions) {
                if (object2 instanceof DHKeyExchange.DHEPossession) {
                    dHEPossession = (DHKeyExchange.DHEPossession)object2;
                    if (x509Possession == null) continue;
                    break;
                }
                if (!(object2 instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)object2;
                if (dHEPossession == null) continue;
                break;
            }
            if (dHEPossession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No DHE credentials negotiated for server key exchange");
            }
            DHPublicKey dHPublicKey = dHEPossession.publicKey;
            object2 = dHPublicKey.getParams();
            this.p = Utilities.toByteArray(((DHParameterSpec)object2).getP());
            this.g = Utilities.toByteArray(((DHParameterSpec)object2).getG());
            this.y = Utilities.toByteArray(dHPublicKey.getY());
            if (x509Possession == null) {
                this.paramsSignature = null;
                this.signatureScheme = null;
                this.useExplicitSigAlgorithm = false;
            } else {
                Map.Entry<SignatureScheme, Signature> entry;
                this.useExplicitSigAlgorithm = serverHandshakeContext.negotiatedProtocol.useTLS12PlusSpec();
                Signature signature = null;
                if (this.useExplicitSigAlgorithm) {
                    entry = SignatureScheme.getSignerOfPreferableAlgorithm(serverHandshakeContext.peerRequestedSignatureSchemes, x509Possession, serverHandshakeContext.negotiatedProtocol);
                    if (entry == null) {
                        throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No supported signature algorithm for " + x509Possession.popPrivateKey.getAlgorithm() + "  key");
                    }
                    this.signatureScheme = entry.getKey();
                    signature = entry.getValue();
                } else {
                    this.signatureScheme = null;
                    try {
                        signature = DHServerKeyExchangeMessage.getSignature(x509Possession.popPrivateKey.getAlgorithm(), x509Possession.popPrivateKey);
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                        throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + x509Possession.popPrivateKey.getAlgorithm(), generalSecurityException);
                    }
                }
                entry = null;
                try {
                    this.updateSignature(signature, serverHandshakeContext.clientHelloRandom.randomBytes, serverHandshakeContext.serverHelloRandom.randomBytes);
                    entry = (Map.Entry<SignatureScheme, Signature>)signature.sign();
                }
                catch (SignatureException signatureException) {
                    throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Failed to sign dhe parameters: " + x509Possession.popPrivateKey.getAlgorithm(), signatureException);
                }
                this.paramsSignature = (byte[])entry;
            }
        }

        DHServerKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            Signature signature;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)handshakeContext;
            this.p = Record.getBytes16(byteBuffer);
            this.g = Record.getBytes16(byteBuffer);
            this.y = Record.getBytes16(byteBuffer);
            try {
                KeyUtil.validate(new DHPublicKeySpec(new BigInteger(1, this.y), new BigInteger(1, this.p), new BigInteger(1, this.p)));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: invalid parameters", invalidKeyException);
            }
            X509Authentication.X509Credentials x509Credentials = null;
            for (SSLCredentials sSLCredentials : clientHandshakeContext.handshakeCredentials) {
                if (!(sSLCredentials instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)sSLCredentials;
                break;
            }
            if (x509Credentials == null) {
                if (byteBuffer.hasRemaining()) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid DH ServerKeyExchange: unknown extra data");
                }
                this.signatureScheme = null;
                this.paramsSignature = null;
                this.useExplicitSigAlgorithm = false;
                return;
            }
            this.useExplicitSigAlgorithm = clientHandshakeContext.negotiatedProtocol.useTLS12PlusSpec();
            if (this.useExplicitSigAlgorithm) {
                int n = Record.getInt16(byteBuffer);
                this.signatureScheme = SignatureScheme.valueOf(n);
                if (this.signatureScheme == null) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature algorithm (" + n + ") used in DH ServerKeyExchange handshake message");
                }
                if (!clientHandshakeContext.localSupportedSignAlgs.contains((Object)this.signatureScheme)) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported signature algorithm (" + this.signatureScheme.name + ") used in DH ServerKeyExchange handshake message");
                }
            } else {
                this.signatureScheme = null;
            }
            this.paramsSignature = Record.getBytes16(byteBuffer);
            if (this.useExplicitSigAlgorithm) {
                try {
                    signature = this.signatureScheme.getVerifier(x509Credentials.popPublicKey);
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                    throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + this.signatureScheme.name, generalSecurityException);
                }
            }
            try {
                signature = DHServerKeyExchangeMessage.getSignature(x509Credentials.popPublicKey.getAlgorithm(), x509Credentials.popPublicKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Unsupported signature algorithm: " + x509Credentials.popPublicKey.getAlgorithm(), generalSecurityException);
            }
            try {
                this.updateSignature(signature, clientHandshakeContext.clientHelloRandom.randomBytes, clientHandshakeContext.serverHelloRandom.randomBytes);
                if (!signature.verify(this.paramsSignature)) {
                    throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Invalid signature on DH ServerKeyExchange message");
                }
            }
            catch (SignatureException signatureException) {
                throw clientHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Cannot verify DH ServerKeyExchange signature", signatureException);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.SERVER_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            int n = 0;
            if (this.paramsSignature != null) {
                n = 2 + this.paramsSignature.length;
                if (this.useExplicitSigAlgorithm) {
                    n += SignatureScheme.sizeInRecord();
                }
            }
            return 6 + this.p.length + this.g.length + this.y.length + n;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.p);
            handshakeOutStream.putBytes16(this.g);
            handshakeOutStream.putBytes16(this.y);
            if (this.paramsSignature != null) {
                if (this.useExplicitSigAlgorithm) {
                    handshakeOutStream.putInt16(this.signatureScheme.id);
                }
                handshakeOutStream.putBytes16(this.paramsSignature);
            }
        }

        public String toString() {
            if (this.paramsSignature == null) {
                MessageFormat messageFormat = new MessageFormat("\"DH ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"dh_p\": '{'\n{0}\n    '}',\n    \"dh_g\": '{'\n{1}\n    '}',\n    \"dh_Ys\": '{'\n{2}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.p), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.g), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.y), "      ")};
                return messageFormat.format(objectArray);
            }
            if (this.useExplicitSigAlgorithm) {
                MessageFormat messageFormat = new MessageFormat("\"DH ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"dh_p\": '{'\n{0}\n    '}',\n    \"dh_g\": '{'\n{1}\n    '}',\n    \"dh_Ys\": '{'\n{2}\n    '}',\n  '}',\n  \"digital signature\":  '{'\n    \"signature algorithm\": \"{3}\"\n    \"signature\": '{'\n{4}\n    '}',\n  '}'\n'}'", Locale.ENGLISH);
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.p), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.g), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.y), "      "), this.signatureScheme.name, Utilities.indent(hexDumpEncoder.encodeBuffer(this.paramsSignature), "      ")};
                return messageFormat.format(objectArray);
            }
            MessageFormat messageFormat = new MessageFormat("\"DH ServerKeyExchange\": '{'\n  \"parameters\": '{'\n    \"dh_p\": '{'\n{0}\n    '}',\n    \"dh_g\": '{'\n{1}\n    '}',\n    \"dh_Ys\": '{'\n{2}\n    '}',\n  '}',\n  \"signature\": '{'\n{3}\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.p), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.g), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.y), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.paramsSignature), "    ")};
            return messageFormat.format(objectArray);
        }

        private static Signature getSignature(String string, Key key) throws NoSuchAlgorithmException, InvalidKeyException {
            Signature signature = null;
            switch (string) {
                case "DSA": {
                    signature = JsseJce.getSignature("DSA");
                    break;
                }
                case "RSA": {
                    signature = RSASignature.getInstance();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException("neither an RSA or a DSA key : " + string);
                }
            }
            if (signature != null) {
                if (key instanceof PublicKey) {
                    signature.initVerify((PublicKey)key);
                } else {
                    signature.initSign((PrivateKey)key);
                }
            }
            return signature;
        }

        private void updateSignature(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            signature.update((byte)(this.p.length >> 8));
            signature.update((byte)(this.p.length & 0xFF));
            signature.update(this.p);
            signature.update((byte)(this.g.length >> 8));
            signature.update((byte)(this.g.length & 0xFF));
            signature.update(this.g);
            signature.update((byte)(this.y.length >> 8));
            signature.update((byte)(this.y.length & 0xFF));
            signature.update(this.y);
        }
    }

    static final class DHServerKeyExchangeProducer
    implements HandshakeProducer {
        private DHServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            DHServerKeyExchangeMessage dHServerKeyExchangeMessage = new DHServerKeyExchangeMessage(serverHandshakeContext);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced DH ServerKeyExchange handshake message", dHServerKeyExchangeMessage);
            }
            dHServerKeyExchangeMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }
}

