/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.args.SubCommand;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.LinkedHashMap;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class Base64Tool
extends CommandLineTool {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    private static final String ARG_NAME_ADD_TRAILING_LINE_BREAK = "addTrailingLineBreak";
    @NotNull
    private static final String ARG_NAME_DATA = "data";
    @NotNull
    private static final String ARG_NAME_IGNORE_TRAILING_LINE_BREAK = "ignoreTrailingLineBreak";
    @NotNull
    private static final String ARG_NAME_INPUT_FILE = "inputFile";
    @NotNull
    private static final String ARG_NAME_OUTPUT_FILE = "outputFile";
    @NotNull
    private static final String ARG_NAME_URL = "url";
    @NotNull
    private static final String SUBCOMMAND_NAME_DECODE = "decode";
    @NotNull
    private static final String SUBCOMMAND_NAME_ENCODE = "encode";
    @Nullable
    private volatile ArgumentParser parser;
    @Nullable
    private final InputStream in;

    public static void main(String ... args) {
        ResultCode resultCode = Base64Tool.main(System.in, System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable InputStream in, @Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        Base64Tool tool = new Base64Tool(in, out, err);
        return tool.runTool(args);
    }

    public Base64Tool(@Nullable OutputStream out, @Nullable OutputStream err) {
        this(null, out, err);
    }

    public Base64Tool(@Nullable InputStream in, @Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
        this.in = in;
        this.parser = null;
    }

    @Override
    @NotNull
    public String getToolName() {
        return "base64";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "Encode raw data using the base64 algorithm or decode base64-encoded data back to its raw representation.";
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.0";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return false;
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        ArgumentParser encodeParser = new ArgumentParser(SUBCOMMAND_NAME_ENCODE, "Base64-encodes raw data.");
        StringArgument encodeDataArgument = new StringArgument(Character.valueOf('d'), ARG_NAME_DATA, false, 1, "{data}", "The raw data to be encoded.  If neither the --data nor the --inputFile argument is provided, then the data will be read from standard input.");
        encodeDataArgument.addLongIdentifier("rawData", true);
        encodeDataArgument.addLongIdentifier("raw-data", true);
        encodeParser.addArgument(encodeDataArgument);
        FileArgument encodeDataFileArgument = new FileArgument(Character.valueOf('f'), ARG_NAME_INPUT_FILE, false, 1, null, "The path to a file containing the raw data to be encoded.  If neither the --data nor the --inputFile argument is provided, then the data will be read from standard input.", true, true, true, false);
        encodeDataFileArgument.addLongIdentifier("rawDataFile", true);
        encodeDataFileArgument.addLongIdentifier("input-file", true);
        encodeDataFileArgument.addLongIdentifier("raw-data-file", true);
        encodeParser.addArgument(encodeDataFileArgument);
        FileArgument encodeOutputFileArgument = new FileArgument(Character.valueOf('o'), ARG_NAME_OUTPUT_FILE, false, 1, null, "The path to a file to which the encoded data should be written.  If this is not provided, the encoded data will be written to standard output.", false, true, true, false);
        encodeOutputFileArgument.addLongIdentifier("toEncodedFile", true);
        encodeOutputFileArgument.addLongIdentifier("output-file", true);
        encodeOutputFileArgument.addLongIdentifier("to-encoded-file", true);
        encodeParser.addArgument(encodeOutputFileArgument);
        BooleanArgument encodeURLArgument = new BooleanArgument(null, ARG_NAME_URL, "Encode the data with the base64url mechanism rather than the standard base64 mechanism.");
        encodeParser.addArgument(encodeURLArgument);
        BooleanArgument encodeIgnoreTrailingEOLArgument = new BooleanArgument(null, ARG_NAME_IGNORE_TRAILING_LINE_BREAK, "Ignore any end-of-line marker that may be present at the end of the data to encode.");
        encodeIgnoreTrailingEOLArgument.addLongIdentifier("ignore-trailing-line-break", true);
        encodeParser.addArgument(encodeIgnoreTrailingEOLArgument);
        encodeParser.addExclusiveArgumentSet(encodeDataArgument, encodeDataFileArgument, new Argument[0]);
        LinkedHashMap<String[], String> encodeExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(3));
        encodeExamples.put(new String[]{SUBCOMMAND_NAME_ENCODE, "--data", "Hello"}, "Base64-encodes the string 'Hello' and writes the result to standard output.");
        encodeExamples.put(new String[]{SUBCOMMAND_NAME_ENCODE, "--inputFile", "raw-data.txt", "--outputFile", "encoded-data.txt"}, "Base64-encodes the data contained in the 'raw-data.txt' file and writes the result to the 'encoded-data.txt' file.");
        encodeExamples.put(new String[]{SUBCOMMAND_NAME_ENCODE}, "Base64-encodes data read from standard input and writes the result to standard output.");
        SubCommand encodeSubCommand = new SubCommand(SUBCOMMAND_NAME_ENCODE, "Base64-encodes raw data.", encodeParser, encodeExamples);
        parser.addSubCommand(encodeSubCommand);
        ArgumentParser decodeParser = new ArgumentParser(SUBCOMMAND_NAME_DECODE, "Decodes base64-encoded data.");
        StringArgument decodeDataArgument = new StringArgument(Character.valueOf('d'), ARG_NAME_DATA, false, 1, "{data}", "The base64-encoded data to be decoded.  If neither the --data nor the --inputFile argument is provided, then the data will be read from standard input.");
        decodeDataArgument.addLongIdentifier("encodedData", true);
        decodeDataArgument.addLongIdentifier("encoded-data", true);
        decodeParser.addArgument(decodeDataArgument);
        FileArgument decodeDataFileArgument = new FileArgument(Character.valueOf('f'), ARG_NAME_INPUT_FILE, false, 1, null, "The path to a file containing the base64-encoded data to be decoded.  If neither the --data nor the --inputFile argument is provided, then the data will be read from standard input.", true, true, true, false);
        decodeDataFileArgument.addLongIdentifier("encodedDataFile", true);
        decodeDataFileArgument.addLongIdentifier("input-file", true);
        decodeDataFileArgument.addLongIdentifier("encoded-data-file", true);
        decodeParser.addArgument(decodeDataFileArgument);
        FileArgument decodeOutputFileArgument = new FileArgument(Character.valueOf('o'), ARG_NAME_OUTPUT_FILE, false, 1, null, "The path to a file to which the decoded data should be written.  If this is not provided, the decoded data will be written to standard output.", false, true, true, false);
        decodeOutputFileArgument.addLongIdentifier("toRawFile", true);
        decodeOutputFileArgument.addLongIdentifier("output-file", true);
        decodeOutputFileArgument.addLongIdentifier("to-raw-file", true);
        decodeParser.addArgument(decodeOutputFileArgument);
        BooleanArgument decodeURLArgument = new BooleanArgument(null, ARG_NAME_URL, "Decode the data with the base64url mechanism rather than the standard base64 mechanism.");
        decodeParser.addArgument(decodeURLArgument);
        BooleanArgument decodeAddTrailingLineBreak = new BooleanArgument(null, ARG_NAME_ADD_TRAILING_LINE_BREAK, "Add a line break to the end of the decoded data.");
        decodeAddTrailingLineBreak.addLongIdentifier("add-trailing-line-break", true);
        decodeParser.addArgument(decodeAddTrailingLineBreak);
        decodeParser.addExclusiveArgumentSet(decodeDataArgument, decodeDataFileArgument, new Argument[0]);
        LinkedHashMap<String[], String> decodeExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(3));
        decodeExamples.put(new String[]{SUBCOMMAND_NAME_DECODE, "--data", "SGVsbG8="}, "Base64-decodes the string 'SGVsbG8=' and writes the result to standard output.");
        decodeExamples.put(new String[]{SUBCOMMAND_NAME_DECODE, "--inputFile", "encoded-data.txt", "--outputFile", "decoded-data.txt"}, "Base64-decodes the data contained in the 'encoded-data.txt' file and writes the result to the 'raw-data.txt' file.");
        decodeExamples.put(new String[]{SUBCOMMAND_NAME_DECODE}, "Base64-decodes data read from standard input and writes the result to standard output.");
        SubCommand decodeSubCommand = new SubCommand(SUBCOMMAND_NAME_DECODE, "Decodes base64-encoded data.", decodeParser, decodeExamples);
        parser.addSubCommand(decodeSubCommand);
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        SubCommand subCommand = this.parser.getSelectedSubCommand();
        if (subCommand == null) {
            this.wrapErr(0, WRAP_COLUMN, "No subcommand was selected.");
            return ResultCode.PARAM_ERROR;
        }
        if (subCommand.hasName(SUBCOMMAND_NAME_ENCODE)) {
            return this.doEncode(subCommand.getArgumentParser());
        }
        return this.doDecode(subCommand.getArgumentParser());
    }

    @NotNull
    private ResultCode doEncode(@NotNull ArgumentParser p) {
        ByteStringBuffer rawDataBuffer = new ByteStringBuffer();
        StringArgument dataArg = p.getStringArgument(ARG_NAME_DATA);
        if (dataArg != null && dataArg.isPresent()) {
            rawDataBuffer.append(dataArg.getValue());
        } else {
            try {
                int bytesRead;
                FileArgument inputFileArg = p.getFileArgument(ARG_NAME_INPUT_FILE);
                InputStream inputStream = inputFileArg != null && inputFileArg.isPresent() ? new FileInputStream(inputFileArg.getValue()) : this.in;
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) > 0) {
                    rawDataBuffer.append(buffer, 0, bytesRead);
                }
                inputStream.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, "An error occurred while attempting to read the data to encode:  ", StaticUtils.getExceptionMessage(e));
                return ResultCode.LOCAL_ERROR;
            }
        }
        BooleanArgument ignoreEOLArg = p.getBooleanArgument(ARG_NAME_IGNORE_TRAILING_LINE_BREAK);
        if (ignoreEOLArg != null && ignoreEOLArg.isPresent()) {
            block8: while (rawDataBuffer.length() > 0) {
                switch (rawDataBuffer.getBackingArray()[rawDataBuffer.length() - 1]) {
                    case 10: 
                    case 13: {
                        rawDataBuffer.delete(rawDataBuffer.length() - 1, 1);
                        continue block8;
                    }
                }
            }
        }
        byte[] rawDataArray = rawDataBuffer.toByteArray();
        ByteStringBuffer encodedDataBuffer = new ByteStringBuffer(4 * rawDataBuffer.length() / 3 + 3);
        BooleanArgument urlArg = p.getBooleanArgument(ARG_NAME_URL);
        if (urlArg != null && urlArg.isPresent()) {
            Base64.urlEncode(rawDataArray, 0, rawDataArray.length, encodedDataBuffer, false);
        } else {
            Base64.encode(rawDataArray, encodedDataBuffer);
        }
        FileArgument outputFileArg = p.getFileArgument(ARG_NAME_OUTPUT_FILE);
        if (outputFileArg != null && outputFileArg.isPresent()) {
            try {
                FileOutputStream outputStream = new FileOutputStream(outputFileArg.getValue(), false);
                encodedDataBuffer.write(outputStream);
                outputStream.write(StaticUtils.EOL_BYTES);
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, "An error occurred while attempting to write the base64-encoded data to output file ", outputFileArg.getValue().getAbsolutePath(), ":  ", StaticUtils.getExceptionMessage(e));
                this.err("Base64-encoded data:");
                this.err(encodedDataBuffer.toString());
                return ResultCode.LOCAL_ERROR;
            }
        } else {
            this.out(encodedDataBuffer.toString());
        }
        return ResultCode.SUCCESS;
    }

    @NotNull
    private ResultCode doDecode(@NotNull ArgumentParser p) {
        FileArgument outputFileArg;
        ByteStringBuffer encodedDataBuffer = new ByteStringBuffer();
        BooleanArgument urlArg = p.getBooleanArgument(ARG_NAME_URL);
        StringArgument dataArg = p.getStringArgument(ARG_NAME_DATA);
        if (dataArg != null && dataArg.isPresent()) {
            encodedDataBuffer.append(dataArg.getValue());
        } else {
            try {
                String line;
                FileArgument inputFileArg = p.getFileArgument(ARG_NAME_INPUT_FILE);
                BufferedReader reader = inputFileArg != null && inputFileArg.isPresent() ? new BufferedReader(new FileReader(inputFileArg.getValue())) : new BufferedReader(new InputStreamReader(this.in));
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith("-") && (urlArg == null || !urlArg.isPresent())) continue;
                    encodedDataBuffer.append(line);
                }
                reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, "An error occurred while attempting to read the data to decode:  ", StaticUtils.getExceptionMessage(e));
                return ResultCode.LOCAL_ERROR;
            }
        }
        ByteStringBuffer rawDataBuffer = new ByteStringBuffer(encodedDataBuffer.length());
        if (urlArg != null && urlArg.isPresent()) {
            try {
                rawDataBuffer.append(Base64.urlDecode(encodedDataBuffer.toString()));
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, "An error occurred while attempting to base64url-decode the provided data:  " + StaticUtils.getExceptionMessage(e));
                return ResultCode.LOCAL_ERROR;
            }
        }
        try {
            rawDataBuffer.append(Base64.decode(encodedDataBuffer.toString()));
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.wrapErr(0, WRAP_COLUMN, "An error occurred while attempting to base64-decode the provided data:  " + StaticUtils.getExceptionMessage(e));
            return ResultCode.LOCAL_ERROR;
        }
        BooleanArgument addEOLArg = p.getBooleanArgument(ARG_NAME_ADD_TRAILING_LINE_BREAK);
        if (addEOLArg != null && addEOLArg.isPresent()) {
            rawDataBuffer.append(StaticUtils.EOL_BYTES);
        }
        if ((outputFileArg = p.getFileArgument(ARG_NAME_OUTPUT_FILE)) != null && outputFileArg.isPresent()) {
            try {
                FileOutputStream outputStream = new FileOutputStream(outputFileArg.getValue(), false);
                rawDataBuffer.write(outputStream);
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, "An error occurred while attempting to write the base64-decoded data to output file ", outputFileArg.getValue().getAbsolutePath(), ":  ", StaticUtils.getExceptionMessage(e));
                this.err("Base64-decoded data:");
                this.err(encodedDataBuffer.toString());
                return ResultCode.LOCAL_ERROR;
            }
        } else {
            byte[] rawDataArray = rawDataBuffer.toByteArray();
            this.getOut().write(rawDataArray, 0, rawDataArray.length);
            this.getOut().flush();
        }
        return ResultCode.SUCCESS;
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        examples.put(new String[]{SUBCOMMAND_NAME_ENCODE, "--data", "Hello"}, "Base64-encodes the string 'Hello' and writes the result to standard output.");
        examples.put(new String[]{SUBCOMMAND_NAME_DECODE, "--inputFile", "encoded-data.txt", "--outputFile", "decoded-data.txt"}, "Base64-decodes the data contained in the 'encoded-data.txt' file and writes the result to the 'raw-data.txt' file.");
        return examples;
    }
}

