<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" 
    xpath-default-namespace="http://oval.mitre.org/XMLSchema/oval-results-5" 
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5" xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="#all" xmlns:functx="http://www.functx.com">

    <xsl:param name="includeUncheckedItems" as="xs:boolean" select="false()"/>
    <xsl:param name="includeRemediation" as="xs:boolean" select="false()"/>
    <xsl:param name="includeTargetIP" as="xs:boolean" select="false()"/>
    <xsl:param name="includeHeaderRow" as="xs:boolean" select="false()"/>
    <xsl:param name="includeUsername" as="xs:boolean" select="false()"/>
    <xsl:param name="includeScoring" as="xs:boolean" select="true()"/>
    <xsl:param name="includeRuleScoring" as="xs:boolean" select="false()"/>
    <xsl:strip-space elements="*"/>
    <xsl:output method="text" encoding="UTF-8"/>
    
    <xsl:variable name="oval_results_system" as="node()" select="/oval-res:oval_results/oval-res:results/oval-res:system"/>
    <xsl:variable name="definitions_def" as="node()" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="definitions_rez" as="node()" select="$oval_results_system/oval-res:definitions"/>
    <xsl:variable name="system_characteristics" as="node()" select="$oval_results_system/oval-sc:oval_system_characteristics"/>
    
    <xsl:variable as="xs:string" name="target" select="$system_characteristics/oval-sc:system_info/oval-sc:primary_host_name"/>
    <xsl:variable name="interfaces" as="node()" select="$system_characteristics/oval-sc:system_info/oval-sc:interfaces"/>
    
    <xsl:variable as="xs:dateTime" name="assessment_date" select="$system_characteristics/oval-sc:generator/oval:timestamp"/>
    
    <xsl:variable name="bInventory" 
        as="xs:boolean" 
        select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'inventory' and @result = 'true' ] ) > 0"/>
    <xsl:variable name="bVulnerability"
        as="xs:boolean" 
        select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'vulnerability' and @result = 'true' ] ) > 0"/>
    <xsl:variable name="bCompliance" 
        as="xs:boolean" 
        select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'compliance' and @result = 'false' ] ) > 0"/>
    <xsl:variable name="bPatch" 
        as="xs:boolean" 
        select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'patch' and @result = 'true' ] ) > 0"/>
    <xsl:variable name="bMiscellaneous" 
        as="xs:boolean" 
        select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'miscellaneous' and @result = 'false' ] ) > 0"/>
    
    <xsl:template match="/" xpath-default-namespace="http://oval.mitre.org/XMLSchema/oval-results-5">
        <xsl:call-template name="add-header"/>
        
        <xsl:if test="$bInventory">
            <xsl:text>&quot;Inventoried Items:&quot;, </xsl:text>
            <xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'inventory' and @result = 'true' ] )"/>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:text>&quot;Definition&quot;,&quot;ID&quot;,&quot;CPE&quot;</xsl:text>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:call-template name="add-data">
                <xsl:with-param name="class">inventory</xsl:with-param>
                <xsl:with-param name="result">true</xsl:with-param>
                <xsl:with-param name="source">CPE</xsl:with-param>
            </xsl:call-template>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
        </xsl:if>
        
        <xsl:if test="$bVulnerability">
            <xsl:text>&quot;Vulnerabilities Discovered:&quot;, </xsl:text>
            <xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'vulnerability' and @result = 'true' ] )"/>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:text>&quot;Definition&quot;,&quot;ID&quot;,&quot;CVE&quot;</xsl:text>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:call-template name="add-data">
                <xsl:with-param name="class">vulnerability</xsl:with-param>
                <xsl:with-param name="result">true</xsl:with-param>
                <xsl:with-param name="source">CVE</xsl:with-param>
            </xsl:call-template>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
        </xsl:if>
        
        <xsl:if test="$bCompliance">
            <xsl:text>&quot;Mis-Configured Items:&quot;, </xsl:text>
            <xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'compliance' and @result = 'false' ] )"/>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:text>&quot;Definition&quot;,&quot;ID&quot;,&quot;CCE&quot;</xsl:text>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:call-template name="add-data">
                <xsl:with-param name="class">compliance</xsl:with-param>
                <xsl:with-param name="result">false</xsl:with-param>
                <xsl:with-param name="source">CCE</xsl:with-param>
            </xsl:call-template>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
        </xsl:if>
        
        <xsl:if test="$bPatch">
            <xsl:text>&quot;Unpatched Items:&quot;, </xsl:text>
            <xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'patch' and @result = 'true' ] )"/>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:text>&quot;Definition&quot;,&quot;ID&quot;,&quot;CCE&quot;</xsl:text>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:call-template name="add-data">
                <xsl:with-param name="class">patch</xsl:with-param>
                <xsl:with-param name="result">true</xsl:with-param>
                <xsl:with-param name="source">CVE</xsl:with-param>
            </xsl:call-template>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
        </xsl:if>
        
        <xsl:if test="$bMiscellaneous">
            <xsl:text>&quot;Miscellaneous Failures:&quot;, </xsl:text>
            <xsl:value-of select="count( /oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = 'miscellaneous' and @result = 'false' ] )"/>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:text>&quot;Definition&quot;,&quot;ID&quot;</xsl:text>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
            
            <xsl:call-template name="add-data">
                <xsl:with-param name="class">miscellaneous</xsl:with-param>
                <xsl:with-param name="result">false</xsl:with-param>
            </xsl:call-template>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
        </xsl:if>
        
    </xsl:template>

    <xsl:template name="add-data" xpath-default-namespace="http://oval.mitre.org/XMLSchema/oval-results-5">
        <xsl:param name="class"/>
        <xsl:param name="result"/>
        <xsl:param name="source" required="no"/>
        
        <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @class = $class and @result = $result ]">
            <xsl:variable name="definition_id" select="@definition_id"/>
            
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="$definitions_def/oval-def:definition[ @id = $definition_id ]/oval-def:metadata/oval-def:title"/>
            <xsl:text>&quot;, </xsl:text>
            
            <xsl:value-of select="$definition_id"/>
            
            <xsl:if test="$source">
                <xsl:if test="$definitions_def/oval-def:definition[ @id = $definition_id ]/oval-def:metadata/oval-def:reference[ @source = $source ]">
                    <xsl:text>, </xsl:text>
                    <xsl:value-of select="$definitions_def/oval-def:definition[ @id = $definition_id ]/oval-def:metadata/oval-def:reference[ @source = $source ]/@ref_id"/>
                </xsl:if>
            </xsl:if>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="add-header" xpath-default-namespace="http://oval.mitre.org/XMLSchema/oval-results-5">
        <xsl:text>&quot;Assessment Target:&quot;,</xsl:text>
        <xsl:text>&quot;</xsl:text>
        <xsl:value-of select="$target"/>
        <xsl:text>&quot;</xsl:text>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        
        <xsl:text>&quot;Assessment Date:&quot;,</xsl:text>
        <xsl:text>&quot;</xsl:text>
        <xsl:value-of select="$assessment_date"/>
        <xsl:text>&quot;</xsl:text>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        
        <xsl:text>&quot;Interfaces:&quot;</xsl:text>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:for-each select="$interfaces/oval-sc:interface">
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="oval-sc:interface_name"/>
            <xsl:text>&quot;,</xsl:text>
            <xsl:text>&quot;</xsl:text>
            <xsl:value-of select="oval-sc:ip_address"/>
            <xsl:text>&quot;</xsl:text>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
        </xsl:for-each>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
    </xsl:template>
</xsl:transform>
