# List the Core Dumps and Network Server Info for each host
$Output =
	Foreach ($VMHost in Get-VMHost ) {
		$ESXCli = Get-EsxCli -V2 -VMHost $VMHost
		$ESXCli.system.coredump.network.get.Invoke() | Select @{N="VMHost";E={$VMHost}}, Enabled, HostVnic, NetworkServerIP, NetworkServerPort
	}
$Output | ConvertTo-Csv -NoTypeInformation