$Output =
    Foreach ($vSwitch in Get-VirtualSwitch -Standard ) {
        $policy = Get-SecurityPolicy -VirtualSwitch $vSwitch
        $Details = New-Object PsObject
        $Details | Add-Member Noteproperty VirtualSwitch -Value $vSwitch
        $Details | Add-Member Noteproperty AllowPromiscuous -Value $policy.AllowPromiscuous
        $Details | Add-Member Noteproperty ForgedTransmits -Value $policy.ForgedTransmits
        $Details | Add-Member Noteproperty MacChanges -Value $policy.MacChanges
        $Details
    }
$Output | ConvertTo-Csv -NoTypeInformation