# List the Software AcceptanceLevel for each host
$Output =
    Foreach ($VMHost in Get-VMHost ) {
        $ESXCli = Get-EsxCli -V2 -VMHost $VMHost
        $VMHost | Select Name, @{N="AcceptanceLevel";E={$ESXCli.software.acceptance.get.Invoke()}}
    }
$Output | ConvertTo-Csv -NoTypeInformation