<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" 
    xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2" 
    xmlns:scap-con="http://scap.nist.gov/schema/scap/constructs/1.2" xmlns:xccdf="http://checklists.nist.gov/xccdf/1.2" xmlns:arf="http://scap.nist.gov/schema/asset-reporting-format/1.1" xmlns:dsc="http://scap.nist.gov/schema/scap/source/1.2" xmlns:ai="http://scap.nist.gov/schema/asset-identification/1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="#all" xmlns:functx="http://www.functx.com">

    <xsl:param name="includeUncheckedItems" as="xs:boolean" select="true()"/>
    <xsl:param name="includeRemediation" as="xs:boolean" select="false()"/>
    <xsl:param name="includeTargetIP" as="xs:boolean" select="false()"/>
    <xsl:param name="includeHeaderRow" as="xs:boolean" select="false()"/>
    <xsl:param name="includeUsername" as="xs:boolean" select="false()"/>
    <xsl:param name="includeScoring" as="xs:boolean" select="true()"/>
    <xsl:param name="includeRuleScoring" as="xs:boolean" select="false()"/>
    <xsl:strip-space elements="*"/>
    <xsl:output method="text" encoding="UTF-8"/>

    <xsl:variable name="selected_benchmark_id" select="/arf:asset-report-collection/arf:reports/arf:report/arf:content/xccdf:TestResult/xccdf:benchmark/@id"/>
    <xsl:variable name="selected_benchmark" as="node()" select="/arf:asset-report-collection/arf:report-requests/arf:report-request/arf:content/dsc:data-stream-collection/dsc:component/xccdf:Benchmark[ @id = $selected_benchmark_id ]"/>
    <xsl:variable name="TestResult" as="node()" select="/arf:asset-report-collection/arf:reports/arf:report/arf:content/xccdf:TestResult"/>
    
    <xsl:variable as="xs:string" name="target" select="$TestResult/target"/>
    <xsl:variable as="xs:string" name="target_ip" select="$TestResult/target-facts/fact[ @name = 'system.ip' ]"/>
    <xsl:variable as="xs:string" name="username" select="$TestResult/target-facts/fact[ @name = 'user.name' ]"/>
    <xsl:variable name="database.name" select="$TestResult/target-facts/fact[ @name = 'database.name' ]"/>
    <xsl:variable name="database.location" select="$TestResult/target-facts/fact[ @name = 'database.location' ]"/>
    
    <xsl:variable as="xs:dateTime" name="date" select="$TestResult/@start-time"/>
    <xsl:variable as="xs:string" name="xccdfVersion" select="$selected_benchmark/version"/>
    <xsl:variable as="xs:string" name="xccdfFilename">
        <xsl:call-template name="lastIndexOf">
            <xsl:with-param name="string" select="$TestResult/benchmark/@href"/>
            <xsl:with-param name="char" select="'/'"/>
        </xsl:call-template>
    </xsl:variable>
    <xsl:variable as="xs:string" name="benchmarkName" select="$selected_benchmark/title"/>
    <xsl:variable as="xs:string" name="benchmarkId" select="$selected_benchmark/@id"/>
    <xsl:variable as="xs:string" name="profileName" select="$selected_benchmark/Profile[ @id = $TestResult/profile/@idref ]/title"/>
    <xsl:variable as="xs:string" name="profileId" select="$selected_benchmark/Profile[ @id = $TestResult/profile/@idref ]/@id"/>
    <xsl:template name="lastIndexOf">
        <!-- declare that it takes two parameters - the string and the char -->
        <xsl:param name="string"/>
        <xsl:param name="char"/>
        <xsl:choose>
            <!-- if the string contains the character... -->
            <xsl:when test="contains($string, $char)">
                <!-- call the template recursively... -->
                <xsl:call-template name="lastIndexOf">
                    <!-- with the string being the string after the character
                     -->
                    <xsl:with-param name="string" select="substring-after($string, $char)"/>
                    <!-- and the character being the same as before -->
                    <xsl:with-param name="char" select="$char"/>
                </xsl:call-template>
            </xsl:when>
            <!-- otherwise, return the value of the string -->
            <xsl:otherwise>
                <xsl:value-of select="$string"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="/" xpath-default-namespace="http://scap.nist.gov/schema/asset-reporting-format/1.1">
        <xsl:apply-templates select="$selected_benchmark"/>
    </xsl:template>
    
    <xsl:template match="Benchmark" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:call-template name="add-header-row"/>
        
        <xsl:apply-templates select="xccdf:Group|xccdf:Rule"/>
        
        <xsl:if test="$includeScoring = true()">
            <xsl:text>Total</xsl:text>
            <xsl:text>,</xsl:text>
            <xsl:text>Pass: </xsl:text>
            <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('pass','fixed') ] )"/>
            <xsl:text>,</xsl:text>
            <xsl:text>Fail: </xsl:text>
            <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('fail') ] )"/>
            <xsl:text>,</xsl:text>
            <xsl:text>Error: </xsl:text>
            <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('error') ] )"/>
            <xsl:text>,</xsl:text>
            <xsl:text>Unknown: </xsl:text>
            <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('unknown') ] )"/>
            <xsl:text>,</xsl:text>
            <xsl:text>Not Selected: </xsl:text>
            <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('notapplicable', 'notchecked', 'informational', 'notselected') ] )"/>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
    
            <xsl:variable name="s2">
                <xsl:call-template name="score-flat-weighted"/>
            </xsl:variable>
            <xsl:text>Actual Pass: </xsl:text>
            <xsl:value-of select="format-number($s2/*/@value,'0.0')"/>
            <xsl:text>,</xsl:text>
            <xsl:text>Maximum Possible: </xsl:text>
            <xsl:value-of select="format-number($s2/*/@weight,'0.0')"/>
            <xsl:text>,</xsl:text>
            <xsl:text>Score: </xsl:text>
            <xsl:variable name="p" select="$s2/*/@value"/>
            <xsl:variable name="t" select="$s2/*/@weight"/>
            <xsl:variable name="s" select="if ($t = 0) then 0 else $p div $t"/>
            <xsl:value-of select="format-number($s*100,'##0')"/>
            <xsl:text>%</xsl:text>
            <xsl:text>&#x0d;&#x0a;</xsl:text>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="Group" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:apply-templates select="xccdf:Group|xccdf:Rule"/>
    </xsl:template>
    
    <xsl:template match="Rule" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:variable name="result" select="$TestResult/xccdf:rule-result[ @idref = current()/@id ]"/>
        
        <xsl:variable name="section">
            <xsl:number count="xccdf:Group|xccdf:Rule" level="multiple"/>
        </xsl:variable>
        <xsl:variable name="the_rule" select="."/>
        <xsl:variable name="weight" select="if (@weight) then @weight else 1"/>
        
        <xsl:for-each select="$result">
            <xsl:variable name="rule_score">
                <xsl:choose>
                    <xsl:when test="matches($result,'pass|fixed')">
                        <xsl:value-of select="1 * $weight"/>
                    </xsl:when>
                    <xsl:when test="matches($result,'fail|error|unknown')">
                        <xsl:value-of select="0"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="0"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <xsl:if test="(($includeUncheckedItems = true()) and xccdf:result != 'notselected' and xccdf:result != 'notapplicable') or ($includeUncheckedItems = false() and $result/xccdf:result != 'notselected' and $result/xccdf:result != 'notchecked')">
                <!-- Remove existing commas and append a comma to end -->
                <!-- Assessment Date -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="format-dateTime($date, '[M01]/[D01]/[Y0001] [H01]:[m01]:[s01]')"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- Target System -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="translate($target, '&#34;', '')"/>
                <xsl:text>&quot;,</xsl:text>
                
                <!-- Target IP, if asked for -->
                <xsl:if test="$includeTargetIP">
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="translate($target_ip, '&#34;', '')"/>
                    <xsl:text>&quot;,</xsl:text>
                </xsl:if>
                
                <!-- Username, if asked for -->
                <xsl:if test="$includeUsername">
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="translate($username, '&#34;', '')"/>
                    <xsl:text>&quot;,</xsl:text>
                </xsl:if>
    
                <!-- DB Location -->
                <xsl:choose>
                    <xsl:when test="$database.location">
                        <xsl:text>&quot;</xsl:text>             
                        <xsl:value-of select="translate($database.location, '&#34;', '')"/>
                        <xsl:text>&quot;,</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>&quot;N/A&quot;,</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
                
                <!-- DB Name -->
                <xsl:choose>
                    <xsl:when test="$database.name">
                        <xsl:text>&quot;</xsl:text>             
                        <xsl:value-of select="translate($database.name, '&#34;', '')"/>
                        <xsl:text>&quot;,</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>&quot;N/A&quot;,</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
    
                <!-- XCCDF Version -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="translate($xccdfVersion,'&#34;', '')"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- XCCDF File Name -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="translate($xccdfFilename,'&#34;', '')"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- Benchmark Name -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="translate($benchmarkName,'&#34;', '')"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- Benchmark ID -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="translate($benchmarkId, '&#34;', '')"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- Profile Name -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="translate($profileName, '&#34;', '')"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- Profile ID -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="translate($profileId, '&#34;', '')"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- Rule ID -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="$the_rule/@id"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- Rule Section Number -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="$section"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- Rule Title -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="normalize-space(translate($the_rule/xccdf:title[1], '&#34;', ''))"/>
                <xsl:text>&quot;,</xsl:text>
    
                <!-- Rule Results -->
                <xsl:text>&quot;</xsl:text>
                <xsl:choose>
                    <xsl:when test="xccdf:result = ('informational','notchecked')">
                        <xsl:text>manual</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="translate(xccdf:result, '&#34;', '')"/>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>&quot;,</xsl:text>
                
                <!-- Rule Score, if asked for -->
                <xsl:if test="$includeRuleScoring">
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="$rule_score"/>
                    <xsl:text>&quot;,</xsl:text>
                </xsl:if>
    
                <!-- CCE-ID -->
                <xsl:text>&quot;</xsl:text>
                <xsl:choose>
                    <xsl:when test="ident">
                        <xsl:value-of select="string-join(xccdf:ident, ',')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>CCE-NONE</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>&quot;</xsl:text>
                
                <!-- Remediation Text, if asked for -->
                <xsl:if test="$includeRemediation">
                    <xsl:text>,&quot;</xsl:text>
                    <xsl:value-of select="normalize-space(translate($the_rule/xccdf:fixtext, '&#34;', ''))"/>
                    <xsl:text>&quot;</xsl:text>
                </xsl:if>
                
                <xsl:text>&#x0d;&#x0a;</xsl:text>
                <!--<xsl:text>&#x0d;</xsl:text>-->
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="add-header-row" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:if test="$includeHeaderRow = true()">
            <!-- Remove existing commas and append a comma to end -->
            <!-- Assessment Date -->
            <xsl:text>&quot;Assessment Date&quot;,</xsl:text>
            
            <!-- Target System -->
            <xsl:text>&quot;Target&quot;,</xsl:text>
            
            <!-- Target IP, if asked for -->
            <xsl:if test="$includeTargetIP">
                <xsl:text>&quot;Target IP&quot;,</xsl:text>
            </xsl:if>
            
            <!-- User name, if asked for -->
            <xsl:if test="$includeUsername">
                <xsl:text>&quot;Username&quot;,</xsl:text>
            </xsl:if>
            
            <!-- DB Location -->
            <xsl:text>&quot;Database Host&quot;,</xsl:text>
            
            <!-- DB Name -->
            <xsl:text>&quot;Database Name&quot;,</xsl:text>
            
            <!-- XCCDF Version -->
            <xsl:text>&quot;Benchmark Version&quot;,</xsl:text>
            
            <!-- XCCDF File Name -->
            <xsl:text>&quot;Benchmark ID&quot;,</xsl:text>
            
            <!-- Benchmark Name -->
            <xsl:text>&quot;Benchmark Name&quot;,</xsl:text>
            
            <!-- Benchmark ID -->
            <xsl:text>&quot;Benchmark ID&quot;,</xsl:text>
            
            <!-- Profile Name -->
            <xsl:text>&quot;Profile&quot;,</xsl:text>
            
            <!-- Profile ID -->
            <xsl:text>&quot;Profile ID&quot;,</xsl:text>
            
            <!-- Rule ID -->
            <xsl:text>&quot;Rule ID&quot;,</xsl:text>
            
            <!-- Rule Section Number -->
            <xsl:text>&quot;Rule Section&quot;,</xsl:text>
            
            <!-- Rule Title -->
            <xsl:text>&quot;Rule Title&quot;,</xsl:text>
            
            <!-- Rule Results -->
            <xsl:text>&quot;Result&quot;,</xsl:text>
            
            <!-- Rule Score, if asked for -->
            <xsl:if test="$includeRuleScoring">
                <xsl:text>,&quot;Rule Score&quot;</xsl:text>
            </xsl:if>
            
            <!-- CCE-ID -->
            <xsl:text>&quot;CCE ID&quot;</xsl:text>
            
            <!-- Remediation Text, if asked for -->
            <xsl:if test="$includeRemediation">
                <xsl:text>,&quot;Remediation&quot;</xsl:text>
            </xsl:if>
            
            <xsl:text>&#x0d;&#x0a;</xsl:text>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="score-flat-weighted" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:choose>
            <xsl:when test="local-name() = 'Rule'">
                <xsl:variable name="weight" select="if (@weight) then @weight else 1" />
                <xsl:variable name="rule-result" select="$TestResult/xccdf:rule-result[@idref=current()/@id]"/>
                <xsl:for-each select="$rule-result">
                    <xsl:choose>
                        <xsl:when test="matches(xccdf:result,'pass|fixed')">
                            <score value="{1 * $weight}" weight="{$weight}"/>
                        </xsl:when>
                        <xsl:when test="matches(xccdf:result,'fail|error|unknown')">
                            <score value="0" weight="{$weight}"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <score value="0" weight="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="matches(local-name(),'Benchmark|Group')">
                <xsl:variable name="scores">
                    <xsl:for-each select="xccdf:Group|xccdf:Rule">
                        <xsl:call-template name="score-flat-weighted"/>
                    </xsl:for-each>
                </xsl:variable>
                <score value="{sum($scores/*/@value)}" weight="{sum($scores/*/@weight)}"/>
            </xsl:when>
            <xsl:otherwise>
                <score value="0" weight="0"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:transform>
