<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns="http://www.w3.org/1999/xhtml" xmlns:cce="http://benchmarks.cisecurity.org/cce/1.0"
               xmlns:controls="http://cisecurity.org/controls" xmlns:cc6="http://cisecurity.org/20-cc/v6.1"
               xmlns:c7="http://cisecurity.org/20-cc/v7.0" xmlns:c8="http://cisecurity.org/20-cc/v8.0"
               xmlns:cc7="http://cisecurity.org/20-cc/v7.0" xmlns:cve="http://benchmarks.cisecurity.org/cve/1.1"
               xmlns:check="local:check" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xhtml="http://www.w3.org/1999/xhtml"
               xmlns:xccdf="http://checklists.nist.gov/xccdf/1.2"
               xmlns:arf="http://scap.nist.gov/schema/asset-reporting-format/1.1"
               xmlns:dsc="http://scap.nist.gov/schema/scap/source/1.2"
               xmlns:ai="http://scap.nist.gov/schema/asset-identification/1.1"
               xmlns:scap-core="http://scap.nist.gov/schema/scap-core/0.3"
               xmlns:cis="http://benchmarks.cisecurity.org/evidence/1.0" xmlns:fn="stylesheet-function"
               xmlns:scap-con="http://scap.nist.gov/schema/scap/constructs/1.2"
               xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
               xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
               xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5"
               xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
               xmlns:ccpd="http://benchmarks.cisecurity.org/ccpd"
               xmlns:output="http://www.w3.org/2010/xslt-xquery-serialization"
               xmlns:xls="http://www.w3.org/1999/XSL/Transform" exclude-result-prefixes="xs" version="3.0">
    <xsl:strip-space elements="*"/>
    <xsl:output method="html" encoding="UTF-8" xmlns="http://www.w3.org/1999/xhtml" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" omit-xml-declaration="yes" indent="yes"/>
    <xsl:output name="serialize" method="xml" omit-xml-declaration="yes" indent="yes" exclude-result-prefixes="#all"/>
    <xsl:character-map name="as-is">
        <xsl:output-character character="&lt;" string="&lt;"/>
        <xsl:output-character character="&gt;" string="&gt;"/>
        <xsl:output-character character="&amp;" string="&amp;"/>
        <xsl:output-character character="&apos;" string="&apos;"/>
        <xsl:output-character character="&quot;" string="&quot;"/>
    </xsl:character-map>
    <xsl:param name="debugging" as="xs:boolean" required="no" select="false()"/>
    <xsl:param name="showXML" as="xs:boolean" required="no" select="true()"/>
    <xsl:param name="embed-link-content" as="xs:boolean" select="true()"/>
    <xsl:param name="profile-code-base" as="xs:integer" select="64"/>
    <xsl:param name="includeUncheckedItems" as="xs:boolean" select="true()"/>

    <xsl:param name="cover_page_url" as="xs:string"/>
    <xsl:param name="logo_url" as="xs:string"/>
    <xsl:param name="cover_page_subtitle_url" as="xs:string"/>
    <xsl:param name="include_default_coverpage_footer" as="xs:boolean" select="true()"/>
    <xsl:param name="cover_page_footer_url" as="xs:string" select="'DEFAULT'"/>
    <xsl:param name="css_content" as="xs:string"/>
    
    <xsl:variable name="hide-unchecked-items" as="xs:boolean" select="matches(processing-instruction('CIS-CAT'),'hide-unchecked-a=.true.')"/>
    <xsl:function name="fn:guillemet">
        <xsl:param name="in" as="item()*"/>
        <xsl:text>«</xsl:text>
        <xsl:value-of select="$in"/>
        <xsl:text>»</xsl:text>
    </xsl:function>
    <xsl:function name="fn:capitalize-first" as="xs:string?">
        <xsl:param name="arg" as="xs:string?"/>
        <xsl:sequence select=" 
            concat(upper-case(substring($arg,1,1)),
            substring($arg,2))
            "/>
    </xsl:function>
    <xsl:function name="fn:count-subsections" as="xs:integer">
        <xsl:param name="arg" as="xs:string?"/>
        <xsl:sequence select="count(tokenize($arg, '[.]')) - 1"/>
    </xsl:function>
    
    <!-- Start: Result Translations -->
    <xsl:function name="fn:translate-result" as="xs:string">
        <xsl:param name="result"/>
        <xsl:param name="class"/>
        
        <xsl:variable name="translate-result">
            <xsl:choose>
                <xsl:when test="$class='vulnerability'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">Vulnerability Found</xsl:when>
                        <xsl:when test="$result='false'">Vulnerability Not Found</xsl:when>
                        <xsl:when test="$result='error'">Error</xsl:when>
                        <xsl:when test="$result='unknown'">Unknown</xsl:when>
                        <xsl:when test="$result='not applicable'">Not Applicable</xsl:when>
                        <xsl:when test="$result='not evaluated'">Not Evaluated</xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'patch'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">Unpatched</xsl:when>
                        <xsl:when test="$result='false'">Patched</xsl:when>
                        <xsl:when test="$result='error'">Error</xsl:when>
                        <xsl:when test="$result='unknown'">Unknown</xsl:when>
                        <xsl:when test="$result='not applicable'">Not Applicable</xsl:when>
                        <xsl:when test="$result='not evaluated'">Not Evaluated</xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'compliance'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">Pass</xsl:when>
                        <xsl:when test="$result='false'">Fail</xsl:when>
                        <xsl:when test="$result='error'">Error</xsl:when>
                        <xsl:when test="$result='unknown'">Unknown</xsl:when>
                        <xsl:when test="$result='not applicable'">Not Applicable</xsl:when>
                        <xsl:when test="$result='not evaluated'">Not Evaluated</xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'inventory'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">Installed</xsl:when>
                        <xsl:when test="$result='false'">Not Installed</xsl:when>
                        <xsl:when test="$result='error'">Error</xsl:when>
                        <xsl:when test="$result='unknown'">Unknown</xsl:when>
                        <xsl:when test="$result='not applicable'">Not Applicable</xsl:when>
                        <xsl:when test="$result='not evaluated'">Not Evaluated</xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>Unknown</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:sequence select="$translate-result"/>
    </xsl:function>
    
    <xsl:function name="fn:translate-result-css" as="xs:string">
        <xsl:param name="result"/>
        <xsl:param name="class"/>
        
        <xsl:variable name="translate-result">
            <xsl:choose>
                <xsl:when test="$class='vulnerability'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">fail</xsl:when>
                        <xsl:when test="$result='false'">pass</xsl:when>
                        <xsl:when test="$result='error'">error</xsl:when>
                        <xsl:otherwise>manual</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'patch'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">fail</xsl:when>
                        <xsl:when test="$result='false'">pass</xsl:when>
                        <xsl:when test="$result='error'">error</xsl:when>
                        <xsl:otherwise>manual</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'compliance'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">pass</xsl:when>
                        <xsl:when test="$result='false'">fail</xsl:when>
                        <xsl:when test="$result='error'">error</xsl:when>
                        <xsl:otherwise>manual</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$class = 'inventory'">
                    <xsl:choose>
                        <xsl:when test="$result='true'">pass</xsl:when>
                        <xsl:when test="$result='false'">fail</xsl:when>
                        <xsl:when test="$result='error'">error</xsl:when>
                        <xsl:otherwise>manual</xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>Unknown</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:sequence select="$translate-result"/>
    </xsl:function>
    <!-- End: Result Translations -->
    
    <xsl:variable name="op-tbl">
        <op op="eq" name="equals">=</op>
        <op op="ne" name="not equal">≠</op>
        <op op="gt" name="greater than">&gt;</op>
        <op op="lt" name="less than">&lt;</op>
        <op op="ge" name="greater than or equal">≥</op>
        <op op="le" name="less than or equal">≤</op>
        <op op="pm" name="pattern match">matches the pattern</op>
        <op op="pn" name="pattern match">does not match the pattern</op>
        <op op="ba" name="bitwise and">∧</op>
        <op op="bo" name="bitwise or">∨</op>
        <!-- ∀  "all" -->
        <!-- ∃  "at least one" -->
        <!-- ∄  "none exist" -->
        <!-- ∃! "only one" -->
        <op op="∃" name="equals">exists</op>
        <op op="∄" name="does not exist">does not exist</op>
    </xsl:variable>
    <xsl:variable name="isCustomized">
        <!--<xsl:choose>
            <xsl:when test="XXSLT:FileExists(concat(XXSLT:GetExecutionPath(),'custom/brand/report.css'))">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:when test="XXSLT:FileExists(concat(XXSLT:GetExecutionPath(),'custom/brand/logo.gif'))">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>-->
        <xsl:value-of select="false()"/>
        <!--</xsl:otherwise>
        </xsl:choose>-->
    </xsl:variable>
    <xsl:function name="fn:op-char">
        <xsl:param name="op" as="xs:string"/>
        <span title="{$op-tbl/*[ @op = $op ]/@name}">
            <xsl:value-of select="$op-tbl/*[ @op = $op ]/text()"/>
        </span>
    </xsl:function>

    <xsl:variable name="selected_benchmark_id" select="/arf:asset-report-collection/arf:reports/arf:report/arf:content/xccdf:TestResult/xccdf:benchmark/@id"/>
    <xsl:variable name="selected_benchmark" as="node()" select="/arf:asset-report-collection/arf:report-requests/arf:report-request/arf:content/dsc:data-stream-collection/dsc:component/xccdf:Benchmark[ @id = $selected_benchmark_id ]"/>
    <xsl:variable name="TestResult" as="node()" select="/arf:asset-report-collection/arf:reports/arf:report/arf:content/xccdf:TestResult"/>

    <!-- determine whether an item is selected  -->
    <xsl:function name="fn:isSelected" as="xs:boolean" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:param name="item" as="element()"/>
        <xsl:param name="profile" as="element()"/>
        <xsl:choose>
            <!-- when a profile has been designated -->
            <xsl:when test=" $profile ">
                <!-- determine selected state based on the profile -->
                <xsl:choose>
                    <!-- when there is a selector for the item -->
                    <xsl:when test="$profile/select[ @idref = $item/@id ]">
                        <!-- use it -->
                        <xsl:value-of select="$profile/select[ @idref = $item/@id ]/@selected cast as xs:boolean"/>
                    </xsl:when>
                    <xsl:when test="$profile/@extends">
                        <xsl:value-of select="fn:isSelected($item, $profile/ancestor::Benchmark/Profile[ @id = $profile/@extends ])"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- otherwise the item retains its individual selection state (default true) -->
                        <xsl:choose>
                            <xsl:when test="$item/@selected">
                                <xsl:value-of select="$item/@selected cast as xs:boolean"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="true()"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <!-- otherwise the item retains its individual selection state (default true) -->
                <xsl:choose>
                    <xsl:when test="$item/@selected">
                        <xsl:value-of select="$item/@selected cast as xs:boolean"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="true()"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    <!-- serialize a node and wrap it in a <pre> tag -->
    <xsl:function name="fn:serialize" as="node()">
        <xsl:param name="node" as="node()"/>
        <xsl:element name="pre" namespace="http://www.w3.org/1999/xhtml">
            <xsl:variable name="output">
                <output:serialization-parameters>
                    <output:indent value="yes"/>
                    <output:method value="xml"/>
                    <output:omit-xml-declaration value="yes"/>
                </output:serialization-parameters>
            </xsl:variable>
            <xsl:analyze-string select="serialize($node, $output/output:serialization-parameters)" regex="(&amp;lt;xccdf:check-content&amp;gt;)(.+)(&amp;lt;/xccdf:check-content&amp;gt;)" flags="m">
                <xsl:matching-substring>
                    <xsl:value-of select="regex-group(1)"/>
                    <span class="highlight">
                        <xsl:value-of select="regex-group(2)"/>
                    </span>
                    <xsl:value-of select="regex-group(3)"/>
                </xsl:matching-substring>
                <xsl:non-matching-substring>
                    <xsl:value-of select="."/>
                </xsl:non-matching-substring>
            </xsl:analyze-string>
        </xsl:element>
    </xsl:function>
    <xsl:template name="score-flat-weighted" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:choose>
            <xsl:when test="local-name() = 'Rule'">
                <xsl:variable name="weight" select="if (@weight) then @weight else 1"/>
                <xsl:variable name="rule-result" select="$TestResult/rule-result[ @idref=current()/@id ]"/>
                <xsl:for-each select="$rule-result">
                    <xsl:choose>
                        <xsl:when test="matches(xccdf:result,'pass|fixed')">
                            <score value="{1 * $weight}" weight="{$weight}"/>
                        </xsl:when>
                        <xsl:when test="matches(xccdf:result,'fail|error|unknown')">
                            <score value="0" weight="{$weight}"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <score value="0" weight="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="matches(local-name(),'Benchmark|Group')">
                <xsl:variable name="scores">
                    <xsl:for-each select="xccdf:Group|xccdf:Rule">
                        <xsl:call-template name="score-flat-weighted"/>
                    </xsl:for-each>
                </xsl:variable>
                <score value="{sum($scores/*/@value)}" weight="{sum($scores/*/@weight)}"/>
            </xsl:when>
            <xsl:otherwise>
                <score value="0" weight="0"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="score-flat-unweighted" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:choose>
            <xsl:when test="local-name() = 'Rule'">
                <xsl:variable name="rule-result" select="$TestResult/rule-result[ @idref=current()/@id ]"/>
                <xsl:for-each select="$rule-result">
                    <xsl:choose>
                        <xsl:when test="matches(xccdf:result,'pass|fixed')">
                            <score value="1" weight="1"/>
                        </xsl:when>
                        <xsl:when test="matches(xccdf:result,'fail|error|unknown')">
                            <score value="0" weight="1"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <score value="0" weight="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="matches(local-name(),'Benchmark|Group')">
                <xsl:variable name="scores">
                    <xsl:for-each select="xccdf:Group|xccdf:Rule">
                        <xsl:call-template name="score-flat-unweighted"/>
                    </xsl:for-each>
                </xsl:variable>
                <score value="{sum($scores/*/@value)}" weight="{sum($scores/*/@weight)}"/>
            </xsl:when>
            <xsl:otherwise>
                <score value="0" weight="0"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="score-default" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:choose>
            <xsl:when test="local-name() = 'Rule'">
                <xsl:variable name="rule-result" select="$TestResult/rule-result[ @idref=current()/@id ]"/>
                <xsl:for-each select="$rule-result">
                    <xsl:choose>
                        <xsl:when test="matches(xccdf:result,'pass')">
                            <score c="1" w="{if (@weight) then @weight else 1}" S="{100 * (if (@weight) then @weight else 1) }"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <score c="1" w="{if (@weight) then @weight else 1}" S="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test=" local-name() = ('Benchmark','Group') ">
                <xsl:variable name="scores">
                    <xsl:for-each select="xccdf:Group|xccdf:Rule">
                        <xsl:call-template name="score-default"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:variable name="c" select="sum($scores/*/@c)"/>
                <xsl:variable name="s" select="sum($scores/*/@S)"/>
                <xsl:variable name="a" select="sum($scores/*/@w)"/>
                <xsl:variable name="n" select="if ($a = 0) then 0 else $s div $a"/>
                <xsl:variable name="w" select="if (@weight) then @weight else 1"/>
                <xsl:variable name="S" select="$n * $w"/>
                <score c="{$c}" s="{$s}" a="{$a}" w="{$w}" S="{$S}"/>
            </xsl:when>
            <xsl:otherwise>
                <score/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="/" xpath-default-namespace="http://scap.nist.gov/schema/asset-reporting-format/1.1">
        <xsl:apply-templates select="$selected_benchmark"/>
    </xsl:template>

    <xsl:template match="Benchmark" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <!-- START: HTML Output... -->
        <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
            <xsl:text>&#x0a;</xsl:text>
            <xsl:comment>
                <xsl:text> This XHTML page was generated by the Configuration Assessment Tool (CIS-CAT) from the Center for Internet Security </xsl:text>
            </xsl:comment>
            <xsl:text>&#x0a;</xsl:text>
            <xsl:comment>
                <xsl:text> For further information, please visit the Center for Internet Security web site at http://benchmarks.cisecurity.org/ </xsl:text>
            </xsl:comment>
            <xsl:text>&#x0a;</xsl:text>
            <xsl:comment>
                <xsl:text> transformation performed </xsl:text>
                <xsl:value-of select="current-dateTime()"/>
                <xsl:text> using </xsl:text>
                <xsl:value-of select="system-property('xsl:vendor')"/>
                <xsl:text> version </xsl:text>
                <xsl:value-of select="system-property('xsl:product-version')"/>
            </xsl:comment>
            <xsl:text>&#x0a;</xsl:text>
            <!-- START: Metadata/Stylesheet/JS information... -->
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
                <meta name="date" content="{current-dateTime()}"/>
                <title>
                    <xsl:text>Benchmark Result </xsl:text>
                    <xsl:value-of select="$TestResult/@id" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2"/>
                </title>
                <!--<xsl:variable name="css">assessor-html.css</xsl:variable>-->
                <xsl:element name="style" namespace="http://www.w3.org/1999/xhtml">
                    <xsl:attribute name="type" select="'text/css'"/>
                    <xsl:value-of select="normalize-space($css_content)" disable-output-escaping="yes"/>
                </xsl:element>
                
                <xsl:variable name="js">assessor-html.js</xsl:variable>
                <xsl:element name="script" namespace="http://www.w3.org/1999/xhtml">
                    <xsl:attribute name="type" select="'text/javascript'"/>
                    <xsl:value-of select="unparsed-text(resolve-uri($js,static-base-uri()))" disable-output-escaping="yes"/>
                </xsl:element>
            </head>
            <!-- END: Metadata/Stylesheet/JS -->

            <!-- START: Main HTML Report body... -->
            <body>
                <div id="reportContainer">

                    <!-- START: Cover Page -->
                    <div class="coverPage" id="top">
                        <xsl:attribute name="style">
                            <xsl:text>background:url(data:image/gif;base64,</xsl:text>
                            <xsl:value-of select="$cover_page_url"/>
                            <xsl:text>) no-repeat;</xsl:text>
                        </xsl:attribute>

                        <div class="logoContainer">
                            <span class="logoBar">
                                <xsl:element name="img">
                                    <xsl:attribute name="src">
                                        <xsl:text>data:image/png;base64,</xsl:text>
                                        <xsl:value-of select="$logo_url"/>
                                    </xsl:attribute>
                                </xsl:element>
                            </span>
                        </div>

                        <div id="coverPageTitle">
                            <h1>Security Configuration Assessment Report</h1>
                            <xsl:choose>
                                <xsl:when test="$TestResult/target-facts/fact[ @name = 'esxi.vmhost' ]">
                                    <h1>for ESXi Host: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'esxi.vmhost' ]"/></h1>
                                </xsl:when>
                                <xsl:when test="$TestResult/target-facts/fact[ @name = 'database.name.1' ]">
                                    <xsl:choose>
                                        <xsl:when test="$TestResult/target-facts/fact[ @name = 'database.location.1' ]">
                                            <xsl:choose>
                                                <xsl:when test="$TestResult/target-facts/fact[ @name = 'instance.name.1' ]">
                                                    <h1>for <xsl:value-of select="$TestResult/target"/></h1>
                                                    <h2>Database Server: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'database.location.1' ]"/></h2>
                                                    <h2>Database: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'database.name.1' ]"/></h2>
                                                    <h2>Instance: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'instance.name.1' ]"/></h2>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <h1>for <xsl:value-of select="$TestResult/target"/></h1>
                                                    <h2>Database Server: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'database.location.1' ]"/></h2>
                                                    <h2>Database: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'database.name.1' ]"/></h2>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:choose>
                                                <xsl:when test="$TestResult/target-facts/fact[ @name = 'instance.name.1' ]">
                                                    <h1>for <xsl:value-of select="$TestResult/target"/></h1>
                                                    <h2>Database: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'database.name.1' ]"/></h2>
                                                    <h2>Instance: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'instance.name.1' ]"/></h2>
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <h1>for <xsl:value-of select="$TestResult/target"/></h1>
                                                    <h2>Database: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'database.name.1' ]"/></h2>
                                                </xsl:otherwise>
                                            </xsl:choose>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </xsl:when>
                                <xsl:when test="$TestResult/target-facts/fact[ @name = 'remote.session' ]">
                                    <h1>for <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'remote.session' ]"/></h1>
                                </xsl:when>
                                <xsl:otherwise>
                                    <h1>for <xsl:value-of select="$TestResult/target"/></h1>
                                    <ul>
                                        <li>Target IP Address: <xsl:value-of select="$TestResult/target-address"/></li>
                                        <xsl:if test="$TestResult/target-facts/fact[ @name = 'user.assigned.machine.name' ]">
                                            <li>Machine Name: <xsl:value-of select="$TestResult/target-facts/fact[ @name = 'user.assigned.machine.name' ]"/></li>
                                        </xsl:if>
                                    </ul>
                                </xsl:otherwise>
                            </xsl:choose>
                        </div>

                        <div id="coverPageSubTitle">
                            <xsl:attribute name="style">
                                <xsl:text>background:url(data:image/gif;base64,</xsl:text>
                                <xsl:value-of select="$cover_page_subtitle_url"/>
                                <xsl:text>) no-repeat;</xsl:text>
                            </xsl:attribute>
                            <h2>
                                <xsl:value-of select="title"/>
                                <xsl:text> </xsl:text>
                                <xsl:variable name="bv" select="version"/>
                                <xsl:if test="not(starts-with($bv, 'v'))">
                                    <xsl:text>v</xsl:text>
                                </xsl:if>

                                <xsl:analyze-string select="$bv" regex="(\d+\.\d+\.\d+\.\d+)">
                                    <xsl:matching-substring>
                                        <xsl:value-of select="regex-group(1)"/>
                                    </xsl:matching-substring>

                                    <xsl:non-matching-substring>
                                        <xsl:value-of select="$bv"/>
                                    </xsl:non-matching-substring>
                                </xsl:analyze-string>
                            </h2>
                            <ul>
                                <xsl:choose>
                                    <xsl:when test="$TestResult/profile">
                                        <li>
                                            <xsl:choose>
                                                <xsl:when test="./Profile[ @id = $TestResult/profile/@idref ]">
                                                    <xsl:value-of select="./Profile[ @id = $TestResult/profile/@idref ]/title"/>
                                                </xsl:when>
                                                <xsl:when test="//Tailoring/Profile[ @id = $TestResult/profile/@idref ]">
                                                    <xsl:value-of select="//Tailoring/Profile[ @id = $TestResult/profile/@idref ]/title"/>
                                                </xsl:when>
                                            </xsl:choose>
                                        </li>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <li>No profile was selected.</li>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <li>
                                    <xsl:value-of select="format-dateTime(adjust-dateTime-to-timezone($TestResult/@start-time),'[FNn], [MNn] [D1] [Y0001] [H01]:[m01]:[s01]')"/>
                                </li>
                                <xsl:variable name="duration" select="xs:dateTime($TestResult/@end-time) - xs:dateTime($TestResult/@start-time)" />
                                <xsl:variable name="durationMinutes" select="round(minutes-from-duration($duration))" />
                                <xsl:variable name="durationSeconds" select="round(seconds-from-duration($duration))" />
                                <li>
                                    Assessment Duration: 
                                    <xsl:choose>
                                        <xsl:when test="$durationMinutes &gt; 1">
                                            <xsl:value-of select="$durationMinutes"/>
                                            <xsl:text> minutes, </xsl:text>
                                        </xsl:when>
                                        <xsl:when test="$durationMinutes = 1">
                                            <xsl:value-of select="$durationMinutes"/>
                                            <xsl:text> minute, </xsl:text>
                                        </xsl:when>
                                    </xsl:choose>
                                    <xsl:value-of select="$durationSeconds"/>
                                    <xsl:text> seconds</xsl:text>
                                </li>
                            </ul>
                        </div>

                        <xsl:choose>
                            <xsl:when test="not($cover_page_footer_url = 'DEFAULT')">
                                <div class="coverpageFooterContainer">
                                    <span class="coverpageFooterBar">
                                        <xsl:element name="img">
                                            <xsl:attribute name="src">
                                                <xsl:text>data:image/png;base64,</xsl:text>
                                                <xsl:value-of select="$cover_page_footer_url"/>
                                            </xsl:attribute>
                                        </xsl:element>
                                    </span>
                                </div>
                            </xsl:when>
                            <xsl:when test="$include_default_coverpage_footer and $cover_page_footer_url = 'DEFAULT' ">
                                <div class="introFooter">
                                    <p>Report generated by the Center for Internet Security's Configuration Assessment Tool (CIS-CAT Pro Assessor) <xsl:if test="$TestResult/xccdf:target-facts/xccdf:fact[ @name = 'application.version' ]">
                                        <xsl:text> v</xsl:text>
                                        <xsl:value-of select="$TestResult/xccdf:target-facts/xccdf:fact[ @name = 'application.version' ]"/>
                                    </xsl:if>. </p>
                                    <p> For further information, please visit <a href="http://benchmarks.cisecurity.org">The Center for Internet Security</a> or our <a href="https://www.cisecurity.org/support/">Product Support</a> page. </p>
                                    <p>Copyright ©<xsl:value-of select="format-dateTime(adjust-dateTime-to-timezone($TestResult/@start-time),'[Y0001]')"/>, The Center for Internet Security</p>
                                    <p>Content generated on <xsl:value-of select="format-dateTime(parent::dsc:component/@timestamp, '[M01]/[D01]/[Y0001] [H01]:[m01] [PN,*-2]')"/>. Content last obtained on <xsl:value-of select="$TestResult/xccdf:target-facts/xccdf:fact[ @name = 'application.build.date']"/>. </p>
                                </div>
                            </xsl:when>
                        </xsl:choose>
                    </div>
                    <!-- END: Cover Page -->

                    <div id="detailsContainer">
                        <!-- START: "Summary" -->
                        <div id="summary">
                            <h2 class="sectionTitle">
                                <xsl:text>Summary</xsl:text>
                            </h2>
                            <table width="100%">
                                <col align="left"/>
                                <col align="center"/>
                                <thead>
                                    <tr>
                                        <th rowspan="2">Description</th>
                                        <xsl:choose>
                                            <xsl:when test="$includeUncheckedItems">
                                                <th colspan="5">Tests</th>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <th colspan="4">Tests</th>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <th colspan="3" title="urn:xccdf:scoring:flat">Scoring</th>
                                    </tr>
                                    <tr>
                                        <th class="pass fixed" title="Pass">Pass</th>
                                        <th class="fail" title="Fail">Fail</th>
                                        <th class="error" title="Error">Error</th>
                                        <th class="unknown" title="Unknown">Unkn.</th>
                                        <xsl:if test="$includeUncheckedItems">
                                            <th title="Manual">Man.</th>
                                        </xsl:if>
                                        <th>Score</th>
                                        <th>Max</th>
                                        <th>Percent</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:apply-templates select="xccdf:Group|xccdf:Rule" mode="summary"/>
                                    <tr>
                                        <th class="group" align="right">Total</th>
                                        <td class="numeric bold">
                                            <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('pass','fixed') ] )"/>
                                        </td>
                                        <td class="numeric bold">
                                            <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('fail') ] )"/>
                                        </td>
                                        <td class="numeric bold">
                                            <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('error') ] )"/>
                                        </td>
                                        <td class="numeric bold">
                                            <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('unknown') ] )"/>
                                        </td>
                                        <xsl:if test="$includeUncheckedItems">
                                            <td class="numeric bold">
                                                <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('notchecked', 'informational') ] )"/>
                                            </td>
                                        </xsl:if>
                                        <xsl:variable name="s2">
                                            <xsl:call-template name="score-flat-weighted"/>
                                        </xsl:variable>
                                        <td class="numeric bold">
                                            <xsl:value-of select="format-number($s2/*/@value,'0.0')"/>
                                        </td>
                                        <td class="numeric bold">
                                            <xsl:value-of select="format-number($s2/*/@weight,'0.0')"/>
                                        </td>
                                        <xsl:variable name="p" select="$s2/*/@value"/>
                                        <xsl:variable name="t" select="$s2/*/@weight"/>
                                        <xsl:variable name="s" select="if ($t = 0) then 0 else $p div $t"/>
                                        <td class="numeric bold">
                                            <xsl:value-of select="format-number($s*100,'##0')"/>
                                            <xsl:text>%</xsl:text>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <p class="caption"><b>Note</b>: Actual scores are subject to rounding errors. The sum of these values may not result in the exact overall score.</p>
                        </div>
                        <!-- END: "Summary" -->


                        <!-- START: "Profiles" Table -->
                        <xsl:if test="Profile">
                            <div id="profiles" class="profiles">
                                <h2 class="sectionTitle">
                                    <xsl:text>Profiles</xsl:text>
                                </h2>
                                <p>
                                    <xsl:variable name="numProfiles" select="count(Profile) + count(//Tailoring/Profile)"/>
                                    <xsl:text>This benchmark contains </xsl:text>
                                    <xsl:choose>
                                        <xsl:when test="$numProfiles &gt; 1">
                                            <xsl:value-of select="$numProfiles"/>
                                            <xsl:text> profiles</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="$numProfiles = 1">
                                            <xsl:text>one profile</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>no profiles</xsl:text>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                    <xsl:text>.</xsl:text>
                                    <xsl:choose>
                                        <xsl:when test="$TestResult/profile">
                                            <xsl:text>The </xsl:text>
                                            <span class="bold">
                                                <xsl:choose>
                                                    <xsl:when test="./Profile[ @id = $TestResult/profile/@idref ]">
                                                        <xsl:value-of select="./Profile[ @id = $TestResult/profile/@idref ]/title"/>
                                                    </xsl:when>
                                                    <xsl:when test="//Tailoring/Profile[ @id = $TestResult/profile/@idref ]">
                                                        <xsl:value-of select="//Tailoring/Profile[ @id = $TestResult/profile/@idref ]/title"/>
                                                    </xsl:when>
                                                </xsl:choose>
                                            </span>
                                            <xsl:text> profile </xsl:text>
                                            <xsl:text> was used for this assessment.</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>No profile was selected for this assessment.</xsl:text>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </p>
                                <table class="profile" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="20%">Title</th>
                                            <th width="80%">Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:for-each select="Profile">
                                            <xsl:variable name="selectedCss">
                                                <xsl:choose>
                                                    <xsl:when test="$TestResult/profile/@idref = @id">
                                                        <xsl:value-of select="' selected-row'"/>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:value-of select="''"/>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:variable>
                                            <tr valign="top" class="{$selectedCss}">
                                                <td>
                                                    <xsl:value-of select="title"/>

                                                    <xsl:if test="@abstract">
                                                        <xsl:if test="@abstract = 'true'">
                                                            <br/>
                                                            <p class="extends">(Not Selectable)</p>
                                                        </xsl:if>
                                                    </xsl:if>
                                                </td>
                                                <td>
                                                    <xsl:apply-templates select="description/node()" mode="xhtml"/>

                                                    <xsl:if test="@extends">
                                                        <br/>
                                                        <p class="extends">
                                                            <xsl:text>Extends </xsl:text>
                                                            <xsl:value-of select="/dsc:data-stream-collection/dsc:component/xccdf:Benchmark/xccdf:Profile[ @id=current()/@extends ]/title"/>
                                                            <xsl:text>.</xsl:text>
                                                        </p>
                                                    </xsl:if>

                                                    <xsl:if test="$showXML">
                                                        <div class="profile-action">
                                                            <span class="action" id="{generate-id()}_xml_button" onclick="switchState('{generate-id()}_xml'); return false;">Show</span>
                                                            <span class="caption"> Profile XML</span>
                                                        </div>
                                                        <div class="xml" id="{generate-id()}_xml">
                                                            <xsl:copy-of select="fn:serialize(.)"/>
                                                        </div>
                                                        <script type="text/javascript">
                                                            <xsl:text>setState('</xsl:text>
                                                            <xsl:value-of select="generate-id()"/>
                                                            <xsl:text>_xml', false);</xsl:text>
                                                        </script>
                                                    </xsl:if>
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                        
                                        <!-- TAILORING PROFILES -->
                                        <xsl:for-each select="//Tailoring/Profile">
                                            <xsl:variable name="selectedCss">
                                                <xsl:choose>
                                                    <xsl:when test="$TestResult/profile/@idref = @id">
                                                        <xsl:value-of select="' selected-row'"/>
                                                    </xsl:when>
                                                    <xsl:otherwise>
                                                        <xsl:value-of select="''"/>
                                                    </xsl:otherwise>
                                                </xsl:choose>
                                            </xsl:variable>
                                            <tr valign="top" class="{$selectedCss}">
                                                <td>
                                                    <xsl:value-of select="title"/>
                                                    
                                                    <xsl:if test="@abstract">
                                                        <xsl:if test="@abstract = 'true'">
                                                            <br/>
                                                            <p class="extends">(Not Selectable)</p>
                                                        </xsl:if>
                                                    </xsl:if>
                                                </td>
                                                <td>
                                                    <xsl:apply-templates select="description/node()" mode="xhtml"/>
                                                    
                                                    <xsl:if test="@extends">
                                                        <br/>
                                                        <p class="extends">
                                                            <xsl:text>Extends </xsl:text>
                                                            <xsl:value-of select="/dsc:data-stream-collection/dsc:component/xccdf:Benchmark/xccdf:Profile[ @id=current()/@extends ]/title"/>
                                                            <xsl:text>.</xsl:text>
                                                        </p>
                                                    </xsl:if>
                                                    
                                                    <xsl:if test="$showXML">
                                                        <div class="profile-action">
                                                            <span class="action" id="{generate-id()}_xml_button" onclick="switchState('{generate-id()}_xml'); return false;">Show</span>
                                                            <span class="caption"> Profile XML</span>
                                                        </div>
                                                        <div class="xml" id="{generate-id()}_xml">
                                                            <xsl:copy-of select="fn:serialize(.)"/>
                                                        </div>
                                                        <script type="text/javascript">
                                                            <xsl:text>setState('</xsl:text>
                                                            <xsl:value-of select="generate-id()"/>
                                                            <xsl:text>_xml', false);</xsl:text>
                                                        </script>
                                                    </xsl:if>
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                                <div class="backtop">
                                    <a href="#top" title="back to top">⇧</a>
                                </div>
                            </div>
                        </xsl:if>
                        <!-- END: "Profiles" Table -->

                        <!-- START: "Assessment Results" ToC -->
                        <div id="checklist">
                            <h2 class="sectionTitle">
                                <xsl:text>Assessment Results</xsl:text>
                            </h2>
                            <div>

                            <div class="outerDiv" style="display: inline">

                                    <div class="innerDiv" id="toggleEssentialHygieneArea" style="float: left">
                                        <input type="checkbox" id="essentialHygieneCheckbox" onclick="checkboxToggled()">Display Only Essential Hygiene (CIS Critical Security Controls V8- IG-1)</input>
                                    </div>
                                <div class="innerDiv" id="toggleFailuresArea" style="float: right">
                                    <input type="checkbox" id="failuresOnlyCheckbox" onclick="checkboxToggled()">Display Only Failures</input>
                                </div>
                            </div>

                            <div id="noControls8Div" class="outerDiv" style="float: left; display: none;">
                                <p style="color:red; float: left; margin: 0;">No mapped CIS Critical Security Controls V8 Safeguards</p>
                            </div>

                            <div class="outerDiv" style="float: left">
                                <a href="#" class="show_hide" id="moreLessLink" style="float: left; margin: 0px 0px 0px 0px;" onclick="toggleHygieneMoreLink();return false;">More</a>
                                <div class="content" id="hygieneMoreInfoDiv" style="display: none; float: left;">
                                    <table class="enum" width="100%" style="float: left;">
                                        <thead align="left">
                                            <tr>
                                                <th colspan="2">CIS Critical Security Controls</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td style="text-align: left;">
                                                    <p style="font-size:11px">
                                                    The CIS Critical Security Controls is a prioritized set of actions to help guide organizations
                                                    in their mission to protect data from cyber-attack vectors. The CIS Critical Security Controls are
                                                    organized into Implementation Groups, a subset of Controls broadly assessed by community consensus
                                                    to be applicable to organizations with similar risk profiles.
                                                    </p>

                                                    <p style="font-size:11px">
                                                    Implementation Group 1 (IG-1) is defined as the foundational set of cyber defense Safeguards that
                                                    every enterprise should apply to guard against the most common attacks.
                                                    </p>

                                                    <p style="font-size:11px">
                                                    CIS Benchmarks best practice guidance help organizations establish system configuration health
                                                    (CIS Control 4). Most best practice recommendations within a CIS Benchmark are mapped to one
                                                    or more CIS Control Safeguards. To help each organization prioritize remediation efforts, we've
                                                    added a filter that allows you to focus on "Fail" results where CIS Controls mappings exist that
                                                    fall into IG-1. Use this filter to help you focus on what to remediate first.
                                                    </p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                                <!--<xsl:if test="$includeUncheckedItems = true()">
                                    <div class="innerDiv"> | </div>
                                    <div class="innerDiv" id="toggleUncheckedItemsArea">
                                        <a href="#" onclick="displayUncheckedAreas();return false;">Display All Defined Tests</a>
                                    </div>
                                </xsl:if>-->
                                <xsl:if test="$hide-unchecked-items">
                                    <p>
                                        <xsl:text>Unchecked tests do not appear in the checklist.</xsl:text>
                                    </p>
                                </xsl:if>
                            </div>

                            <table id="assessmentResultTable" width="100%">
                                <thead>
                                    <tr>
                                        <th title="weight" class="serif">w</th>
                                        <th>Benchmark Item</th>
                                        <th>Result</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:apply-templates select="xccdf:Group|xccdf:Rule" mode="assessment_results"/>
                                </tbody>
                            </table>
                            <div class="backtop">
                                <a href="#top" title="back to top">⇧</a>
                            </div>
                        </div>
                        <!-- END: "Assessment Results" ToC -->

                        <!-- START: "Assessment Details" -->
                        <div id="assessmentDetailsArea">
                            <h2 class="sectionTitle">
                                <xsl:text>Assessment Details</xsl:text>
                            </h2>
                            <div id="front-matter">
                                <xsl:apply-templates mode="xhtml" select="xccdf:front-matter/*"/>
                            </div>

                            <xsl:apply-templates select="xccdf:Group|xccdf:Rule" mode="assessment_details"/>
                        </div>
                        <!-- END: "Assessment Details" -->

                        <div id="rear-matter">
                            <xsl:apply-templates mode="xhtml" select="xccdf:rear-matter/*"/>
                            <div class="backtop">
                                <a href="#top" title="back to top">⇧</a>
                            </div>
                        </div>

                        <div id="footerContainer">
                            <div class="footerBar">
                                <br/>
                            </div>
                        </div>
                    </div>
                </div>
            </body>
            <!-- END: Main HTML Report body... -->
        </html>
        <!-- END: HTML Output... -->
    </xsl:template>

    <xsl:template match="Group" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2" mode="summary">
        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[START -\- Group (Summary)]</xsl:with-param>
        </xsl:call-template>-->

        <tr>
            <xsl:if test="boolean(ancestor-or-self::*[@hidden = 'true'])">
                <xsl:attribute name="class" select="'hidden'"/>
            </xsl:if>
            <xsl:variable name="num">
                <xsl:number count="xccdf:Group|xccdf:Rule" level="multiple"/>
            </xsl:variable>
            <xsl:variable name="num_subs" select="fn:count-subsections($num)"/>
            <xsl:variable name="subClass">
                <xsl:choose>
                    <xsl:when test="$num_subs = 0">
                        <xsl:value-of select="' sub0'"/>
                    </xsl:when>
                    <xsl:when test="$num_subs = 1">
                        <xsl:value-of select="' sub1'"/>
                    </xsl:when>
                    <xsl:when test="$num_subs = 2">
                        <xsl:value-of select="' sub2'"/>
                    </xsl:when>
                    <xsl:when test="$num_subs = 3">
                        <xsl:value-of select="' sub3'"/>
                    </xsl:when>
                    <xsl:when test="$num_subs = 4">
                        <xsl:value-of select="' sub4'"/>
                    </xsl:when>
                    <xsl:when test="$num_subs = 5">
                        <xsl:value-of select="' sub5'"/>
                    </xsl:when>
                    <xsl:when test="$num_subs = 6">
                        <xsl:value-of select="' sub6'"/>
                    </xsl:when>
                    <xsl:when test="$num_subs = 7">
                        <xsl:value-of select="' sub7'"/>
                    </xsl:when>
                    <xsl:when test="$num_subs = 8">
                        <xsl:value-of select="' sub8'"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="''"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <td id="summary-{generate-id()}" class="group {$subClass}">
                <xsl:value-of select="$num"/>
                <xsl:text> </xsl:text>
                <a href="#checklist-{generate-id()}">
                    <xsl:value-of select="if (xccdf:title) then xccdf:title else concat(@id,' ')"/>
                </a>
            </td>
            <xsl:variable name="ids" select="descendant-or-self::xccdf:Rule/@id"/>
            <td class="numeric {$subClass}">
                <xsl:value-of select="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = ('pass','fixed') ] )"/>
            </td>
            <td class="numeric {$subClass}">
                <xsl:value-of select="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = 'fail' ] )"/>
            </td>
            <td class="numeric {$subClass}">
                <xsl:value-of select="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = 'error' ] )"/>
            </td>
            <td class="numeric {$subClass}">
                <xsl:value-of select="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = 'unknown' ] )"/>
            </td>
            <xsl:if test="$includeUncheckedItems">
                <td class="numeric {$subClass}">
                    <xsl:value-of select="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = ('notchecked', 'informational') ] )"/>
                </td>
            </xsl:if>
            <xsl:variable name="s2">
                <xsl:call-template name="score-flat-weighted"/>
            </xsl:variable>
            <td class="numeric {$subClass}">
                <xsl:value-of select="format-number($s2/*/@value,'0.0')"/>
            </td>
            <td class="numeric {$subClass}">
                <xsl:value-of select="format-number($s2/*/@weight,'0.0')"/>
            </td>
            <xsl:variable name="p" select="$s2/*/@value"/>
            <xsl:variable name="t" select="$s2/*/@weight"/>
            <xsl:variable name="s" select="if ($t = 0) then 0 else $p div $t"/>
            <td class="numeric {$subClass}">
                <xsl:value-of select="format-number($s*100,'##0')"/>
                <xsl:text>%</xsl:text>
            </td>
        </tr>
        <xsl:apply-templates select="xccdf:Group" mode="summary"/>

        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[END -\- Group (Summary)]</xsl:with-param>
        </xsl:call-template>-->
    </xsl:template>

    <xsl:template match="Rule" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2" mode="summary">
        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[START -\- Rule (Summary)]</xsl:with-param>
        </xsl:call-template>-->

        <tr>
            <xsl:if test="boolean(ancestor-or-self::*[@hidden = 'true'])">
                <xsl:attribute name="class" select="'hidden'"/>
            </xsl:if>
            <td class="rule">
                <xsl:number count="xccdf:Group|xccdf:Rule" level="multiple"/>
                <xsl:text> </xsl:text>
                <a href="#checklist-{generate-id()}">
                    <xsl:value-of select="if (xccdf:title) then xccdf:title else concat(@id,' ')"/>
                </a>
            </td>
            <xsl:variable name="ids" select="descendant-or-self::Rule/@id"/>
            <td class="numeric">
                <xsl:value-of select="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = ('pass','fixed') ] )"/>
            </td>
            <td class="numeric">
                <xsl:value-of select="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = 'fail' ] )"/>
            </td>
            <td class="numeric">
                <xsl:value-of select="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = 'error' ] )"/>
            </td>
            <td class="numeric">
                <xsl:value-of select="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = 'unknown' ] )"/>
            </td>
            <xsl:if test="$includeUncheckedItems">
                <td class="numeric">
                    <xsl:value-of select="count( $TestResult/xccdf:rule-result[  @idref = ($ids) and xccdf:result = ('notchecked', 'informational') ] )"/>
                </td>
            </xsl:if>
            <xsl:variable name="s2">
                <xsl:call-template name="score-flat-weighted"/>
            </xsl:variable>
            <td class="numeric">
                <xsl:value-of select="format-number($s2/*/@value,'0.000')"/>
            </td>
            <td class="numeric">
                <xsl:value-of select="format-number($s2/*/@weight,'0.000')"/>
            </td>
            <td class="numeric">
                <xsl:choose>
                    <xsl:when test="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = ('pass','fixed') ] ) >= 1">
                        <xsl:text>100%</xsl:text>
                    </xsl:when>
                    <xsl:when test="count( $TestResult/xccdf:rule-result[ @idref = ($ids) and xccdf:result = 'fail' ] ) >= 1">
                        <xsl:text>0%</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>N/A</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
        </tr>
        <xsl:apply-templates select="xccdf:Group" mode="summary"/>

        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[END -\- Rule (Summary)]</xsl:with-param>
        </xsl:call-template>-->
    </xsl:template>

    <xsl:template match="Group" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2" mode="assessment_results">
        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[START -\- Group (Assessment Results)]</xsl:with-param>
        </xsl:call-template>-->

        <xsl:variable name="ids" select="descendant-or-self::xccdf:Rule/@id"/>
        <tr>
            <xsl:if test="boolean(ancestor-or-self::*[@hidden = 'true'])">
                <xsl:attribute name="class" select="'hidden'"/>
            </xsl:if>
            <td id="checklist-{generate-id()}" class="group sect" colspan="3">
                <a href="#detail-{generate-id()}">
                    <xsl:number count="xccdf:Group|xccdf:Rule" level="multiple"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="if (xccdf:title) then xccdf:title else concat(@id,' ')"/>
                </a>
            </td>
        </tr>
        <xsl:apply-templates select="xccdf:Group|xccdf:Rule" mode="assessment_results"/>

        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[END -\- Group (Assessment Results)]</xsl:with-param>
        </xsl:call-template>-->
    </xsl:template>

    <xsl:template match="Rule" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2" mode="assessment_results">
        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[START -\- Rule (Assessment Results)]</xsl:with-param>
        </xsl:call-template>-->

        <xsl:variable name="section">
            <xsl:number count="xccdf:Group|xccdf:Rule" level="multiple"/>
        </xsl:variable>
        <xsl:variable name="the_rule" select="."/>
        <xsl:variable name="result" select="$TestResult/xccdf:rule-result[ @idref = current()/@id ]"/>
        <xsl:for-each select="$result">
            <xsl:if test="(($includeUncheckedItems = true()) and xccdf:result != 'notselected' and xccdf:result != 'notapplicable') or ($includeUncheckedItems = false() and xccdf:result != 'notselected' and xccdf:result != 'notchecked' and xccdf:result != 'notapplicable')">
                <xsl:variable name="controlURI" select="$the_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:8.0' ]/controls:safeguard/@urn"></xsl:variable>
                <xsl:variable name="sub_node" select="doc('20cc/cis_controls_v8_0.xml')/c8:critical_controls/c8:controls/c8:control/c8:subcontrols/c8:subcontrol[ @subcontrolURI = $controlURI]"/>
                <xsl:variable name="cssClass">
                <xsl:variable name="ig1check">
                    <xsl:for-each select="$the_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:8.0' ]/controls:safeguard">
                        <xsl:variable name="controlURI2" select="./@urn"/>
                        <xsl:variable name="sub_node2" select="doc('20cc/cis_controls_v8_0.xml')/c8:critical_controls/c8:controls/c8:control/c8:subcontrols/c8:subcontrol[ @subcontrolURI = $controlURI2]"/>
                        <xsl:if test="$sub_node2/c8:subcontrol-implementation-group = ('IG-1')">
                            <xsl:text>true</xsl:text>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:variable>
                    <xsl:choose>
                        <xsl:when test="xccdf:result = ('notselected','notapplicable')">
                            <xsl:value-of select="'notSelectedArea tableHidden'"/>
                        </xsl:when>
                        <xsl:when test="xccdf:result = ('pass','fixed','error','unknown','informational','notchecked')
                            and not($controlURI)">
                            <xsl:value-of select="'nonCriticalControlArea nonFailureArea  tableVisible'"/>
                        </xsl:when>
                        <xsl:when test="xccdf:result = ('pass','fixed','error','unknown','informational','notchecked')">
                            <xsl:if test="not(contains($ig1check,'true'))">
                                <xsl:value-of select="'nonCriticalControlArea nonFailureArea tableVisible'"/>
                            </xsl:if>
                            <xsl:if test="contains($ig1check,'true')">
                                <xsl:value-of select="'nonFailureArea tableVisible'"/>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test="xccdf:result = ('pass','fixed','error','unknown','informational','notchecked')">
                            <xsl:value-of select="'nonFailureArea tableVisible'"/>
                        </xsl:when>
                        <xsl:when test="not($controlURI)"> <!-- Controls not in metadata -->
                            <xsl:value-of select="'nonCriticalControlArea tableVisible'"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="not(contains($ig1check,'true'))">
                                <xsl:value-of select="'nonCriticalControlArea tableVisible'"/>
                            </xsl:if>
                            <xsl:if test="contains($ig1check,'true')">
                                <xsl:value-of select="'resultRow'"/>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <tr class="{$cssClass}">
                    <xsl:if test=" boolean(ancestor-or-self::*[@hidden = 'true']) ">
                        <xsl:attribute name="class" select="'hidden'"/>
                    </xsl:if>
                    <xsl:if test=" $hide-unchecked-items and (xccdf:result = 'notselected' or xccdf:result = 'notapplicable') ">
                        <xsl:attribute name="class" select="'hidden'"/>
                    </xsl:if>
                    <td>
                        <xsl:choose>
                            <xsl:when test="xccdf:result = ('pass','fixed','fail','error','unknown')">
                                <span class="weight">
                                    <xsl:value-of select="format-number( if (@weight) then @weight else 1, '0.0#' )"/>
                                </span>
                            </xsl:when>
                            <xsl:otherwise>
                                <br/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                    <td>
                        <a href="#detail-{generate-id()}">
                            <xsl:value-of select="$section"/>
                            <xsl:text> </xsl:text>
                            <xsl:value-of select="if ($the_rule/xccdf:title) then $the_rule/xccdf:title else concat($the_rule/@id,' ')"/>
                        </a>
                    </td>
                    <td class="numeric">
                        <span>
                            <a href="#detail-{generate-id()}">
                                <xsl:choose>
                                    <xsl:when test="xccdf:result = ('informational','notchecked')">
                                        <span class="informational">
                                            <xsl:text>Manual</xsl:text>
                                        </span>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <span class="{xccdf:result}">
                                            <xsl:value-of select="fn:capitalize-first(result)"/>
                                        </span>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </a>
                        </span>
                    </td>
                </tr>
            </xsl:if>
        </xsl:for-each>
        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[END -\- Rule (Assessment Results)]</xsl:with-param>
        </xsl:call-template>-->
    </xsl:template>

    <xsl:template name="selected" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:param name="rule-id" required="yes"/>
        <xsl:choose>
            <xsl:when test="fn:isSelected($rule-id,.)">
                <span>✓</span>
            </xsl:when>
            <xsl:otherwise>
                <span>∙</span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="Group" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2" mode="assessment_details">
        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[START -\- Group (Assessment Details)]</xsl:with-param>
        </xsl:call-template>-->

        <div id="detail-{generate-id()}" class="group">
            <xsl:if test="boolean(ancestor-or-self::*[@hidden = 'true'])">
                <xsl:attribute name="class" select="'hidden'"/>
            </xsl:if>
            <h2 class="ruleGroupTitle">
                <xsl:attribute name="title">
                    <xsl:value-of select="@id"/>
                </xsl:attribute>
                <xsl:number count="xccdf:Group|xccdf:Rule" level="multiple"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="xccdf:title"/>
            </h2>
            <xsl:if test="xccdf:description/node()">
                <div class="description">
                    <xsl:apply-templates select="xccdf:description/node()" mode="xhtml"/>
                </div>
            </xsl:if>

            <xsl:call-template name="references"/>

            <xsl:if test="xccdf:warning/node()">
                <div class="warning">
                    <xsl:apply-templates select="xccdf:warning/node()" mode="xhtml"/>
                </div>
            </xsl:if>
            <xsl:if test="xccdf:rationale/node()">
                <div class="rationale">
                    <xsl:apply-templates select="xccdf:rationale/node()" mode="xhtml"/>
                </div>
            </xsl:if>
        </div>
        <xsl:apply-templates select="xccdf:Group|xccdf:Rule" mode="assessment_details"/>

        <!--<xsl:call-template name="log">
            <xsl:with-param name="msg">[END -\- Group (Assessment Details)]</xsl:with-param>
        </xsl:call-template>-->
    </xsl:template>

    <xsl:template name="references" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:param name="hasControlsV7MappedInMetadata" />
        <xsl:if test="(reference[not(starts-with(@href,'SCAP#'))] and ((count(reference[node()]) > 0)) or (count(ident) > 0))">
            <div class="reference">
                <p>
                    <span>
                        <xsl:attribute name="title">
                            <xsl:value-of select="count(reference)"/>
                        </xsl:attribute>
                        <span class="bold">
                            <xsl:text>References: </xsl:text>
                        </span>
                    </span>
                    <ul class="referenceList">
                        <xsl:for-each select="reference[not(starts-with(@href,'SCAP#'))]">
                            <xsl:if test="node()">
                                <li>
                                    <xsl:choose>
                                        <xsl:when test="@href">
                                            <a href="{@href}">
                                                <xsl:value-of select="."/>
                                            </a>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="."/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </li>
                            </xsl:if>
                        </xsl:for-each>
                        <xsl:if test="ident">
                            <xsl:apply-templates select="ident[not(starts-with(@system,'http://cisecurity.org/20-cc/'))]"/>
                        </xsl:if>
                    </ul>
                </p>

                <xsl:if test="(count(ident[ @system = 'http://cisecurity.org/20-cc/v7.0' ]) > 0) and (not($hasControlsV7MappedInMetadata))">
                    <p>
                        <span>
                            <xsl:attribute name="title">
                                <xsl:value-of select="count(ident[ @system = 'http://cisecurity.org/20-cc/v7.0' ])"/>
                            </xsl:attribute>
                            <span class="bold">
                                <xsl:text>CIS Controls V7.0: </xsl:text>
                            </span>
                        </span>
                        <ul class="referenceList">
                            <xsl:apply-templates select="ident[ @system eq 'http://cisecurity.org/20-cc/v7.0' ]"/>
                        </ul>
                    </p>
                </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="Rule" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2" mode="assessment_details">
        <xsl:variable name="section">
            <xsl:number count="xccdf:Group|xccdf:Rule" level="multiple"/>
        </xsl:variable>
        <xsl:variable name="the_rule" select="."/>
        <xsl:variable name="result" select="$TestResult/xccdf:rule-result[ @idref = current()/@id ]"/>

        <xsl:for-each select="$result">
            <xsl:if test="(($includeUncheckedItems = true()) and xccdf:result != 'notselected' and xccdf:result != 'notapplicable') or ($includeUncheckedItems = false() and xccdf:result != 'notselected' and xccdf:result != 'notchecked' and xccdf:result != 'notapplicable')">
                <xsl:variable name="controlURI" select="$the_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:8.0' ]/controls:safeguard/@urn"></xsl:variable>
                <xsl:variable name="sub_node" select="doc('20cc/cis_controls_v8_0.xml')/c8:critical_controls/c8:controls/c8:control/c8:subcontrols/c8:subcontrol[ @subcontrolURI = $controlURI]"/>
                <xsl:variable name="cssClass">
                    <xsl:variable name="ig1check">
                        <xsl:for-each select="$the_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:8.0' ]/controls:safeguard">
                            <xsl:variable name="controlURI2" select="./@urn"/>
                            <xsl:variable name="sub_node2" select="doc('20cc/cis_controls_v8_0.xml')/c8:critical_controls/c8:controls/c8:control/c8:subcontrols/c8:subcontrol[ @subcontrolURI = $controlURI2]"/>
                            <xsl:if test="$sub_node2/c8:subcontrol-implementation-group = ('IG-1')">
                                <xsl:text>true</xsl:text>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:variable>
                    <xsl:choose>
                        <xsl:when test="xccdf:result = ('notselected','notapplicable')">
                            <xsl:value-of select="'notSelectedArea hidden'"/>
                        </xsl:when>
                        <xsl:when test="xccdf:result = ('pass','fixed','error','unknown','informational','notchecked')
                            and not($controlURI)">
                            <xsl:value-of select="'nonCriticalControlArea nonFailureArea  visible'"/>
                        </xsl:when>
                        <xsl:when test="xccdf:result = ('pass','fixed','error','unknown','informational','notchecked')">
                            <xsl:if test="not(contains($ig1check,'true'))">
                                <xsl:value-of select="'nonCriticalControlArea nonFailureArea visible'"/>
                            </xsl:if>
                            <xsl:if test="contains($ig1check,'true')">
                                <xsl:value-of select="'nonFailureArea visible'"/>
                            </xsl:if>
                        </xsl:when>
                        <xsl:when test="xccdf:result = ('pass','fixed','error','unknown','informational','notchecked')">
                            <xsl:value-of select="'nonFailureArea visible'"/>
                        </xsl:when>
                        <xsl:when test="not($controlURI)"> <!-- Controls not in metadata -->
                            <xsl:value-of select="'nonCriticalControlArea visible'"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="not(contains($ig1check,'true'))">
                                <xsl:value-of select="'nonCriticalControlArea visible'"/>
                            </xsl:if>
                            <xsl:if test="contains($ig1check,'true')">
                                <xsl:value-of select="'resultRow'"/>
                            </xsl:if>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <div id="detail-{generate-id()}" class="Rule {$cssClass}">
                    <xsl:if test="boolean(ancestor-or-self::*[@hidden = 'true'])">
                        <xsl:attribute name="class" select="'hidden'"/>
                    </xsl:if>
                    <span class="outcome {xccdf:result} ruleResultArea">
                        <xsl:choose>
                            <xsl:when test="xccdf:result = ('informational','notchecked')">
                                <xsl:text>Manual</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="fn:capitalize-first(result)"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </span>
                    <h3 class="ruleTitle">
                        <xsl:attribute name="title">
                            <xsl:value-of select="$the_rule/@id"/>
                        </xsl:attribute>
                        <!--<xsl:number count="xccdf:Group|xccdf:Rule" level="multiple"/>-->
                        <xsl:value-of select="$section"/>
                        <xsl:text> </xsl:text>
                        <xsl:if test="$the_rule/xccdf:title">
                            <xsl:value-of select="$the_rule/xccdf:title"/>
                        </xsl:if>
                    </h3>
                    <xsl:if test="$the_rule/xccdf:question">
                        <div class="question">
                            <xsl:value-of select="$the_rule/xccdf:question"/>
                        </div>
                    </xsl:if>
                    <div class="description">
                        <xsl:choose>
                            <xsl:when test="$the_rule/xccdf:description and exists($the_rule/xccdf:description/node())">
                                <div class="bold">Description:</div>
                                <xsl:apply-templates select="$the_rule/xccdf:description/node()" mode="xhtml"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>No description</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                    <xsl:choose>
                        <xsl:when test="$the_rule/xccdf:warning and exists($the_rule/xccdf:warning/node())">
                            <div class="warning">
                                <xsl:apply-templates select="$the_rule/xccdf:warning/node()" mode="xhtml"/>
                            </div>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="$the_rule/xccdf:rationale and exists($the_rule/xccdf:rationale/node())">
                            <div class="rationale">
                                <xsl:apply-templates select="$the_rule/xccdf:rationale/node()" mode="xhtml"/>
                            </div>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="$the_rule/xccdf:fixtext and exists($the_rule/xccdf:fixtext/node())">
                            <div class="fixtext">
                                <xsl:apply-templates select="$the_rule/xccdf:fixtext/node()" mode="xhtml"/>
                            </div>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="$the_rule/xccdf:fix">
                            <div class="fix">
                                <dl>
                                    <xsl:for-each select="$the_rule/xccdf:fix">
                                        <dt>
                                            <span>
                                                <xsl:value-of select="@platform"/>
                                            </span>
                                        </dt>
                                        <dd>
                                            <xsl:variable name="fix_text" select="."/>
                                            <xsl:choose>
                                                <xsl:when test="string-length($fix_text) > 0">
                                                    <code>
                                                        <xsl:value-of select="$fix_text"/>
                                                    </code>
                                                </xsl:when>
                                                <xsl:otherwise> No remediation instructions specified. </xsl:otherwise>
                                            </xsl:choose>
                                        </dd>
                                    </xsl:for-each>
                                </dl>
                            </div>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="message and exists(message/node())">
                            <div class="message">
                                <ul>
                                    <xsl:for-each select="message">
                                        <li>
                                            <xsl:apply-templates select="./node()" mode="xhtml"/>
                                        </li>
                                    </xsl:for-each>
                                </ul>
                            </div>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:choose>
                        <xsl:when test="check">
                            <!-- Generate the "Test(s)" Box -->
                            <div id="detail-{generate-id()}" class="check">
                                <div>
                                    <span class="action" id="{generate-id()}_evidence_button" onclick="switchState('{generate-id()}_evidence'); return false;">Show</span>
                                    <span class="caption"> Assessment Evidence</span>
                                </div>
                                
                                <div class="xml" id="{generate-id()}_evidence">
                                    <xsl:apply-templates select="complex-check|check" mode="evidence"/>
                                </div>
                            </div>
                        </xsl:when>
                        <xsl:when test="complex-check">
                            <!-- Generate the "Test(s)" Box -->
                            <div id="detail-{generate-id()}" class="check">
                                <div>
                                    <span class="action" id="{generate-id()}_evidence_button" onclick="switchState('{generate-id()}_evidence'); return false;">Show</span>
                                    <span class="caption"> Assessment Evidence</span>
                                </div>
                                
                                <div class="xml" id="{generate-id()}_evidence">
                                    <xsl:apply-templates select="complex-check|check" mode="evidence"/>
                                </div>
                            </div>
                        </xsl:when>
                    </xsl:choose>
                    <br/>

                    <!-- Generate the "Show Rule Result XML" -->
                    <xsl:if test="$showXML">
                        <div>
                            <span class="action" id="{generate-id()}_xml_result_button" onclick="switchState('{generate-id()}_xml_result'); return false;">Show</span>
                            <span class="caption"> Rule Result XML</span>
                        </div>
                        <div class="xml" id="{generate-id()}_xml_result">
                            <xsl:copy-of select="fn:serialize(.)"/>
                        </div>
                        <script type="text/javascript">
                            <xsl:text>setState('</xsl:text>
                            <xsl:value-of select="generate-id()"/>
                            <xsl:text>_xml_result', false);</xsl:text>
                        </script>
                    </xsl:if>

                    <xsl:call-template name="references">
                        <xsl:with-param name="hasControlsV7MappedInMetadata" select="boolean(/$the_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:7.0' ])" />
                    </xsl:call-template>

                    <!-- Add CIS Controls reference information from metadata - BEGIN -->
                    <xsl:if test="count($the_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:7.0' ]) > 0">
                        <p>
                            <span>
                                <xsl:attribute name="title">
                                    <xsl:value-of select="count(controls:framework)"/>
                                </xsl:attribute>
                                <span class="bold">
                                    <xsl:text>CIS Controls V7.0: </xsl:text>
                                </span>
                            </span>
                            <ul class="referenceList">
                                <xsl:apply-templates select="$the_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:7.0' ]">
                                    <xsl:with-param name="current_rule" select="$the_rule" />
                                </xsl:apply-templates>>
                            </ul>
                        </p>
                    </xsl:if>

                    <xsl:if test="count($the_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:8.0' ]) > 0">
                        <p>
                            <span>
                                <xsl:attribute name="title">
                                    <xsl:value-of select="count(controls:framework)"/>
                                </xsl:attribute>
                                <span class="bold">
                                    <xsl:text>CIS Critical Security Controls V8.0: </xsl:text>
                                </span>
                            </span>

                            <ul class="referenceList">
                                <xsl:apply-templates select="$the_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:8.0' ]">
                                    <xsl:with-param name="current_rule" select="$the_rule" />
                                </xsl:apply-templates>>
                            </ul>
                        </p>
                    </xsl:if>
                    <!-- Add CIS Controls reference information from metadata - END -->

                    <div class="backtop">
                        <a href="#summary-{generate-id($the_rule/parent::Group)}" title="back to summary">Back to Summary</a>
                    </div>
                </div>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="ident[ @system = 'cce.mitre.org/version/4' ]" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <li>
            <span class="bold">CCE-IDv4: </span>
            <a href="http://cce.mitre.org/" class="CCE-link">
                <xsl:value-of select="."/>
            </a>
        </li>
    </xsl:template>

    <xsl:template match="ident[ @system = 'http://cce.mitre.org' ]" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:variable name="cce_id" select="." as="xs:string"/>
        <xsl:variable name="cce_node" select="doc('cce/nvd_cce_map.xml')/cce:cce_map/cce:cce_entry[ @id = $cce_id]"/>
        <li>
            <b>CCE-IDv5: </b>
            <a href="http://cce.mitre.org/" class="CCE-link"><xsl:value-of select="$cce_id"/></a> -- <span class="cce-action" id="{generate-id()}_xml_button" onclick="switchStateML('{generate-id()}_xml'); return false;">More</span>
            <div class="cceevidence rule-xml" id="{generate-id()}_xml">
                <table class="enum" width="100%">
                    <thead>
                        <tr>
                            <th colspan="2">CCE Information</th>
                        </tr>
                    </thead>
                    <tr>
                        <td class="enum_name" width="20%">CCE-IDv5:</td>
                        <td width="80%"><xsl:value-of select="$cce_id"/></td>
                    </tr>
                    <tr>
                        <td class="enum_name" width="20%">Published On:</td>
                        <td width="80%"><xsl:value-of select="format-dateTime($cce_node/@published, '[M01]/[D01]/[Y0001] at [H01]:[m01]:[s01]')"/></td>
                    </tr>
                    <tr>
                        <td class="enum_name" width="20%">Last Modified On:</td>
                        <td width="80%"><xsl:value-of select="format-dateTime($cce_node/@modified, '[M01]/[D01]/[Y0001] at [H01]:[m01]:[s01]')"/></td>
                    </tr>
                    <xsl:if test="$cce_node/scap-core:control-mappings">
                        <tr>
                            <td colspan="2">
                                <table class="enum" width="100%">
                                    <thead>
                                        <tr>
                                            <th colspan="2">Compliance Mappings</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:for-each select="$cce_node/scap-core:control-mappings/scap-core:control-mapping">
                                            <tr>
                                                <td class="enum_name" width="20%">Last Modified:</td>
                                                <td width="80%"><xsl:value-of select="format-dateTime(./@last-modified, '[M01]/[D01]/[Y0001] at [H01]:[m01]:[s01]')"/></td>
                                            </tr>
                                            <tr>
                                                <td class="enum_name" width="20%">Source:</td>
                                                <td width="80%">
                                                    <xsl:element name="a">
                                                        <xsl:attribute name="href" select="./@source"/>
                                                        <xsl:value-of select="./@source"/>
                                                    </xsl:element>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="enum_name" width="20%">System:</td>
                                                <td width="80%">
                                                    <xsl:element name="a">
                                                        <xsl:attribute name="href" select="./@system-id"/>
                                                        <xsl:value-of select="./@system-id"/>
                                                    </xsl:element>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="2">
                                                    <table class="enum" width="100%">
                                                        <thead>
                                                            <tr>
                                                                <th>Mapping</th>
                                                                <th>Published</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <xsl:for-each select="./scap-core:mapping">
                                                                <tr>
                                                                    <td width="20%"><xsl:value-of select="./text()"/></td>
                                                                    <td width="80%"><xsl:value-of select="format-dateTime(./@published, '[M01]/[D01]/[Y0001] at [H01]:[m01]:[s01]')"/></td>
                                                                </tr>
                                                            </xsl:for-each>
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </xsl:if>
                </table>
            </div>
            <script type="text/javascript"><xsl:text>setStateML('</xsl:text><xsl:value-of select="generate-id()"/><xsl:text>_xml', false);</xsl:text></script>
        </li>
    </xsl:template>

    <xsl:template match="ident[ @system = 'http://cisecurity.org/20-cc/v7.0' ]" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:variable name="control" select="./@cc7:controlURI" as="xs:string"/>
        <xsl:variable name="sub_node" select="doc('20cc/critical_controls_v7_0.xml')/cc7:critical_controls/cc7:controls/cc7:control/cc7:subcontrols/cc7:subcontrol[ @subcontrolURI = $control]"/>

        <xsl:choose>
            <xsl:when test="$sub_node">
                <xsl:variable name="parent" select="$sub_node/parent::node()/parent::node()"/>
                <li>
                    <b><xsl:value-of select="$parent/cc7:control_label"/>: </b> -- <span class="cce-action" id="{generate-id()}_xml_button" onclick="switchStateML('{generate-id()}_xml'); return false;">More</span>
                    <div class="cceevidence rule-xml" id="{generate-id()}_xml">
                        <table class="enum" width="100%">
                            <thead>
                                <tr>
                                    <th colspan="2">CIS Control Information</th>
                                </tr>
                            </thead>
                            <tr>
                                <td class="enum_name" width="20%">Control:</td>
                                <td width="80%"><xsl:value-of select="$parent/cc7:control_objective"/></td>
                            </tr>
                            <tr>
                                <td class="enum_name" width="20%">Subcontrol:</td>
                                <td width="80%"><xsl:value-of select="$sub_node/@id"/></td>
                            </tr>
                            <tr>
                                <td class="enum_name" width="20%">Label:</td>
                                <td width="80%"><xsl:value-of select="$sub_node/cc7:subcontrol_label"/></td>
                            </tr>
                            <tr>
                                <td class="enum_name" width="20%">Description:</td>
                                <td width="80%"><xsl:value-of select="$sub_node/cc7:subcontrol_desc"/></td>
                            </tr>
                        </table>
                    </div>
                    <script type="text/javascript"><xsl:text>setStateML('</xsl:text><xsl:value-of select="generate-id()"/><xsl:text>_xml', false);</xsl:text></script>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="ctl_node" select="doc('20cc/critical_controls_v7_0.xml')/cc7:critical_controls/cc7:controls/cc7:control[ @controlURI = $control]"/>
                <li>
                    <b><xsl:value-of select="$ctl_node/cc7:control_label"/>: </b> -- <span class="cce-action" id="{generate-id()}_xml_button" onclick="switchStateML('{generate-id()}_xml'); return false;">More</span>
                    <div class="cceevidence rule-xml" id="{generate-id()}_xml">
                        <table class="enum" width="100%">
                            <thead>
                                <tr>
                                    <th colspan="2">CIS Control Information</th>
                                </tr>
                            </thead>
                            <tr>
                                <td class="enum_name" width="20%">Control:</td>
                                <td width="80%"><xsl:value-of select="$ctl_node/cc7:control_objective"/></td>
                            </tr>
                        </table>
                    </div>
                    <script type="text/javascript"><xsl:text>setStateML('</xsl:text><xsl:value-of select="generate-id()"/><xsl:text>_xml', false);</xsl:text></script>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:7.0' ]" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:param name="current_rule" />

        <xsl:for-each select="$current_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:7.0' ]/controls:control">
            <xsl:variable name="controlURI" select="./@urn" as="xs:string"/>
            <xsl:variable name="ctl_node" select="doc('20cc/cis_controls_v7_0.xml')/c7:critical_controls/c7:controls/c7:control[ @controlURI = $controlURI]"/>

            <li>
                <b><xsl:value-of select="$ctl_node/c7:control_label"/>: </b> -- <span class="cce-action" id="{generate-id()}_xml_button" onclick="switchStateML('{generate-id()}_xml'); return false;">More</span>
                <div class="cceevidence rule-xml" id="{generate-id()}_xml">
                    <table class="enum" width="100%">
                        <thead>
                            <tr>
                                <th colspan="2">CIS Control Information</th>
                            </tr>
                        </thead>
                        <tr>
                            <td class="enum_name" width="20%">Control:</td>
                            <td width="80%"><xsl:value-of select="$ctl_node/c7:control_objective"/></td>
                        </tr>
                    </table>
                </div>
                <script type="text/javascript"><xsl:text>setStateML('</xsl:text><xsl:value-of select="generate-id()"/><xsl:text>_xml', false);</xsl:text></script>
            </li>
        </xsl:for-each>

        <xsl:for-each select="$current_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:7.0' ]/controls:safeguard">
            <xsl:variable name="controlURI" select="./@urn" as="xs:string"/>
            <xsl:variable name="sub_node" select="doc('20cc/cis_controls_v7_0.xml')/c7:critical_controls/c7:controls/c7:control/c7:subcontrols/c7:subcontrol[ @subcontrolURI = $controlURI]"/>
            <xsl:variable name="parent" select="$sub_node/parent::node()/parent::node()"/>

            <li>
                <b><xsl:value-of select="$parent/c7:control_label"/>: </b> -- <span class="cce-action" id="{generate-id()}_xml_button" onclick="switchStateML('{generate-id()}_xml'); return false;">More</span>
                <div class="cceevidence rule-xml" id="{generate-id()}_xml">
                    <table class="enum" width="100%">
                        <thead>
                            <tr>
                                <th colspan="2">CIS Control Information</th>
                            </tr>
                        </thead>
                        <tr>
                            <td class="enum_name" width="20%">Control:</td>
                            <td width="80%"><xsl:value-of select="$parent/c7:control_objective"/></td>
                        </tr>
                        <tr>
                            <td class="enum_name" width="20%">Subcontrol:</td>
                            <td width="80%"><xsl:value-of select="$sub_node/@id"/></td>
                        </tr>
                        <tr>
                            <td class="enum_name" width="20%">Label:</td>
                            <td width="80%"><xsl:value-of select="$sub_node/c7:subcontrol_label"/></td>
                        </tr>
                        <tr>
                            <td class="enum_name" width="20%">Description:</td>
                            <td width="80%"><xsl:value-of select="$sub_node/c7:subcontrol_desc"/></td>
                        </tr>
                    </table>
                </div>
                <script type="text/javascript"><xsl:text>setStateML('</xsl:text><xsl:value-of select="generate-id()"/><xsl:text>_xml', false);</xsl:text></script>
            </li>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:8.0' ]" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:param name="current_rule" />

        <xsl:for-each select="$current_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:8.0' ]/controls:control">
            <xsl:variable name="controlURI" select="./@urn" as="xs:string"/>
            <xsl:variable name="ctl_node" select="doc('20cc/cis_controls_v8_0.xml')/c8:critical_controls/c8:controls/c8:control[ @controlURI = $controlURI]"/>

            <li>
                <b><xsl:value-of select="$ctl_node/c8:control_label"/>: </b> -- <span class="cce-action" id="{generate-id()}_xml_button" onclick="switchStateML('{generate-id()}_xml'); return false;">More</span>
                <div class="cceevidence rule-xml" id="{generate-id()}_xml">
                    <table class="enum" width="100%">
                        <thead>
                            <tr>
                                <th colspan="2">CIS Control Information</th>
                            </tr>
                        </thead>
                        <tr>
                            <td class="enum_name" width="20%">Control:</td>
                            <td width="80%"><xsl:value-of select="$ctl_node/c8:control_objective"/></td>
                        </tr>
                    </table>
                </div>
                <script type="text/javascript"><xsl:text>setStateML('</xsl:text><xsl:value-of select="generate-id()"/><xsl:text>_xml', false);</xsl:text></script>
            </li>
        </xsl:for-each>

        <xsl:for-each select="$current_rule/metadata/controls:cis_controls/controls:framework[ @urn = 'urn:cisecurity.org:controls:8.0' ]/controls:safeguard">
            <xsl:variable name="controlURI" select="./@urn" as="xs:string"/>
            <xsl:variable name="sub_node" select="doc('20cc/cis_controls_v8_0.xml')/c8:critical_controls/c8:controls/c8:control/c8:subcontrols/c8:subcontrol[ @subcontrolURI = $controlURI]"/>
            <xsl:variable name="parent" select="$sub_node/parent::node()/parent::node()"/>

            <li>
                <b><xsl:value-of select="$parent/c8:control_label"/>: </b> -- <span class="cce-action" id="{generate-id()}_xml_button" onclick="switchStateML('{generate-id()}_xml'); return false;">More</span>
                <div class="cceevidence rule-xml" id="{generate-id()}_xml">
                    <table class="enum" width="100%">
                        <thead>
                            <tr>
                                <th colspan="2">CIS Control Information</th>
                            </tr>
                        </thead>
                        <tr>
                            <td class="enum_name" width="20%">Control:</td>
                            <td width="80%"><xsl:value-of select="$parent/c8:control_objective"/></td>
                        </tr>
                        <tr>
                            <td class="enum_name" width="20%">Safeguard:</td>
                            <td width="80%"><xsl:value-of select="$sub_node/@id"/></td>
                        </tr>
                        <tr>
                            <td class="enum_name" width="20%">Label:</td>
                            <td width="80%"><xsl:value-of select="$sub_node/c8:subcontrol_label"/></td>
                        </tr>
                        <tr>
                            <td class="enum_name" width="20%">Description:</td>
                            <td width="80%"><xsl:value-of select="$sub_node/c8:subcontrol_desc"/></td>
                        </tr>
                        <tr>
                            <td class="enum_name" width="20%">Implementation Group:</td>
                            <td width="80%"><xsl:value-of select="$sub_node/c8:subcontrol-implementation-group"/></td>
                        </tr>
                        <tr>
                            <td class="enum_name" width="20%">Security Function:</td>
                            <td width="80%"><xsl:value-of select="$sub_node/c8:subcontrol_security_function"/></td>
                        </tr>
                    </table>
                </div>
                <script type="text/javascript"><xsl:text>setStateML('</xsl:text><xsl:value-of select="generate-id()"/><xsl:text>_xml', false);</xsl:text></script>
            </li>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="ident[ @system = 'http://cve.mitre.org' ]" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:variable name="ref_id" select="."/>
        <xsl:variable name="cve-year" as="xs:double" select="number(substring($ref_id, 5, 4))"/>
        <xsl:variable name="cve-document">
            <xsl:choose>
                <xsl:when test="$cve-year &lt; 2002 or $cve-year = 2002">
                    <xsl:value-of select="concat('cve/nvdcve_cve_cvss_map-', '2002', '.xml')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('cve/nvdcve_cve_cvss_map-', string($cve-year), '.xml')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="cve-available" select="doc-available($cve-document)"/>
        <xsl:choose>
            <xsl:when test="$cve-available">
                <xsl:variable name="cve_node" select="doc($cve-document)/cve:cve_cvss_map/cve:entry[ @id = $ref_id]"/>
                <xsl:choose>
                    <xsl:when test="$cve_node">
                        <li>
                            <b>CVE-ID: </b>
                            <xsl:element name="a">
                                <xsl:attribute name="href">http://web.nvd.nist.gov/view/vuln/detail?vulnId=<xsl:value-of select="$ref_id"/></xsl:attribute>
                                <xsl:value-of select="$ref_id"/>
                            </xsl:element>

                            <table class="enum" width="100%">
                                <thead>
                                    <tr>
                                        <th colspan="2">CVE Information</th>
                                    </tr>
                                </thead>
                                <tr>
                                    <td class="enum_name" width="20%">Summary:</td>
                                    <td width="80%">
                                        <xsl:value-of select="$cve_node/text()"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="enum_name" width="20%">Severity:</td>
                                    <td width="80%">
                                        <xsl:value-of select="$cve_node/@cvss_base"/>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="enum_name" width="20%">Access Vector:</td>
                                    <td width="80%">
                                        <xsl:value-of select="$cve_node/@cvss_vector_string"/>
                                    </td>
                                </tr>
                            </table>
                        </li>
                    </xsl:when>
                    <xsl:otherwise>
                        <li>
                            <b>CVE-ID: </b>
                            <xsl:element name="a">
                                <xsl:attribute name="href">http://web.nvd.nist.gov/view/vuln/detail?vulnId=<xsl:value-of select="$ref_id"/></xsl:attribute>
                                <xsl:value-of select="$ref_id"/>
                            </xsl:element>
                        </li>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <li>
                    <b>CVE-ID: </b>
                    <xsl:element name="a">
                        <xsl:attribute name="href">http://web.nvd.nist.gov/view/vuln/detail?vulnId=<xsl:value-of select="$ref_id"/></xsl:attribute>
                        <xsl:value-of select="$ref_id"/>
                    </xsl:element>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:function name="fn:prr" as="node()">
        <xsl:param name="cn" as="node()"/>
        
        <xsl:variable name="p" select="$cn/parent::node()"/>
        <xsl:choose>
            <xsl:when test="$p[local-name() = 'rule-result']">
                <xsl:copy-of select="$p"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="fn:prr($p)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <xsl:template match="check[ @system = 'http://open-scap.org/page/SCE' ]" mode="evidence" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:apply-templates select="evidence" xpath-default-namespace="http://cisecurity.org/evidence"/>
    </xsl:template>
    
    <xsl:template match="check[ @system = 'http://oval.mitre.org/XMLSchema/oval-definitions-5']" mode="evidence" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:apply-templates select="evidence" xpath-default-namespace="http://cisecurity.org/evidence"/>
    </xsl:template>
    
    <xsl:template match="check[ @system = 'http://cisecurity.org/check']" mode="evidence" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:apply-templates select="evidence" xpath-default-namespace="http://cisecurity.org/evidence"/>
    </xsl:template>
    
    <xsl:template match="complex-check" mode="evidence" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <table class="evidence-sep" width="100%">
            <caption class="bold">Complex Check</caption>
            <tr>
                <td class="bold" width="5%">
                    <xsl:value-of select="@operator"/>
                </td>
                <td width="95%">
                    <xsl:apply-templates select="complex-check|check" mode="evidence"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="evidence" xpath-default-namespace="http://cisecurity.org/evidence">
        <xsl:copy-of select="node()"/>
    </xsl:template>

    <xsl:function name="fn:translate-op" as="xs:string?">
        <xsl:param name="op" as="xs:string?"/>
        <xsl:param name="neg" as="xs:boolean"/>
        
        <xsl:choose>
            <xsl:when test="$op = 'equals' and $neg = false()">
                <xsl:text> to be set to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'equals' and $neg = true()">
                <xsl:text> to not be set to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'case insensitive equals' and $neg = false()">
                <xsl:text> to be set to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'case insensitive equals' and $neg = true()">
                <xsl:text> to not be set to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'greater than or equal' and $neg = false()">
                <xsl:text> to be greater than or equal to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'greater than or equal' and $neg = true()">
                <xsl:text> to be less than </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'greater than' and $neg = false()">
                <xsl:text> to be greater than </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'greater than' and $neg = true()">
                <xsl:text> to be less than or equal to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'not equal' and $neg = false()">
                <xsl:text> to not be set to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'not equal' and $neg = true()">
                <xsl:text> to be set to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'case insensitive not equal' and $neg = false()">
                <xsl:text> to not be set to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'case insensitive not equal' and $neg = true()">
                <xsl:text> to be set to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'less than or equal' and $neg = false()">
                <xsl:text> to be less than or equal to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'less than or equal' and $neg = true()">
                <xsl:text> to be greater than </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'less than' and $neg = false()">
                <xsl:text> to be less than </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'less than' and $neg = true()">
                <xsl:text> to be greater than or equal to </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'pattern match' and $neg = false()">
                <xsl:text> matches the regular expression </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'pattern match' and $neg = true()">
                <xsl:text> does not match the regular expression </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'subset of' and $neg = false()">
                <xsl:text> to be a subset of </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'subset of' and $neg = true()">
                <xsl:text> to not be a subset of </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'superset of' and $neg = false()">
                <xsl:text> to be a superset of </xsl:text>
            </xsl:when>
            <xsl:when test="$op = 'superset of' and $neg = true()">
                <xsl:text> to not be a superset of </xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text> unknown </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

    <xsl:function name="fn:isBMPartOfNewEvidence" as="xs:boolean">
        <xsl:param name="bm_id" as="xs:string"/>
        <xsl:sequence select="$bm_id eq 'xccdf_org.cisecurity.benchmarks_benchmark_1.4.0_CIS_Microsoft_Windows_10_Enterprise_Release_1709_Benchmark'
            or $bm_id eq 'xccdf_org.cisecurity.benchmarks_benchmark_1.8.0_CIS_Microsoft_Windows_10_Enterprise_Release_1909_Benchmark'
            or $bm_id eq 'xccdf_org.cisecurity.benchmarks_benchmark_1.7.0_CIS_Microsoft_Windows_10_Enterprise_Release_1903_Benchmark'
            or $bm_id eq 'xccdf_org.cisecurity.benchmarks_benchmark_1.6.1_CIS_Microsoft_Windows_10_Enterprise_Release_1809_Benchmark'
            or $bm_id eq 'xccdf_org.cisecurity.benchmarks_benchmark_1.5.0.1_CIS_Microsoft_Windows_10_Enterprise_Release_1803_Benchmark'
            or $bm_id eq 'xccdf_org.cisecurity.benchmarks_benchmark_1.3.0_CIS_Microsoft_Windows_10_Enterprise_Release_1703_Benchmark'"/>
    </xsl:function>

    <xsl:template match="ident" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <li>
            <span class="bold">
                <xsl:value-of select="@system"/>
                <xsl:text>: </xsl:text>
            </span>
            <xsl:value-of select="."/>
        </li>
    </xsl:template>
    <xsl:template match="check" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="check-content" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:choose>
            <xsl:when test="*:check-result">
                <ul>
                    <xsl:apply-templates/>
                </ul>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="complex-check" xpath-default-namespace="local:check">
        <xsl:if test=" position() != 1 ">
            <li class="operator">
                <xsl:value-of select="../@operator"/>
            </li>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="./../name() = 'check:complex-check'">
                <li>
                    <ul>
                        <xsl:apply-templates select="complex-check|check-result"/>
                    </ul>
                </li>
            </xsl:when>
            <xsl:otherwise>
                <ul>
                    <xsl:apply-templates select="complex-check|check-result"/>
                </ul>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="check-result" xpath-default-namespace="local:check">
        <xsl:if test=" position() != 1 ">
            <li class="operator">
                <xsl:value-of select="../@operator"/>
            </li>
        </xsl:if>
        <li>
            <span class="{outcome}">
                <xsl:value-of select="if (node()[1]/@comment != '') then node()[1]/@comment else local-name(node()[1])"/>
            </span>
            <xsl:choose>
                <xsl:when test="check" xpath-default-namespace="http://cisecurity.org/check">
                    <xsl:choose>
                        <xsl:when test="check/@op">
                            <xsl:text> </xsl:text>
                            <xsl:value-of select="fn:op-char(check/@op)"/>
                            <xsl:if test="@value">
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="fn:guillemet(check/@value)"/>
                            </xsl:if>
                        </xsl:when>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
            <br/>
            <xsl:apply-templates select="node()[1]" mode="check"/>
        </li>
    </xsl:template>

    <xsl:template mode="check" match="check" xpath-default-namespace="http://cisecurity.org/check">
        <code class="shell">
            <xsl:value-of select="*"/>
        </code>
        <xsl:variable name="content" as="xs:string">
            <xsl:value-of select="following-sibling::*[1]//out" xpath-default-namespace=""/>
        </xsl:variable>
        <xsl:for-each select="tokenize($content,'↵+')">
            <xsl:if test=".">
                <samp class="pre">
                    <xsl:value-of select="."/>
                </samp>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    <xsl:template mode="check" match="evaluate" xpath-default-namespace="http://cisecurity.org/check">
        <code>
            <xsl:apply-templates mode="evaluate" select="*"/>
            <xsl:call-template name="format-value-attr"/>
        </code>
        <xsl:apply-templates mode="result" select="following-sibling::*[1]"/>
    </xsl:template>
    <xsl:template mode="check" match="simple-command|shell-command" xpath-default-namespace="http://cisecurity.org/check">
        <!--<div><br /></div>-->
        <div>
            <span class="action" id="{generate-id()}_xml_button" onclick="switchState('{generate-id()}_xml'); return false;">Show</span>
            <span class="caption"> Command Output</span>
        </div>
        <div class="cmd rule-xml" id="{generate-id()}_xml">
            <code class="shell">
                <!--<xsl:value-of select="following-sibling::*[1]/command" xpath-default-namespace=""/>-->
                <xsl:value-of select="command" xpath-default-namespace="http://cisecurity.org/check"/>
            </code>
            <xsl:if test="@success = 'pass'">
                <span class="hint">
                    <xsl:text> (check fails if command fails)</xsl:text>
                </span>
            </xsl:if>
            <xsl:if test="@success = 'fail'">
                <span class="hint">
                    <xsl:text> (check fails if command succeeds)</xsl:text>
                </span>
            </xsl:if>
            <xsl:if test="@check = 'all'">
                <span class="hint">
                    <xsl:text> (check fails if no output present)</xsl:text>
                </span>
            </xsl:if>
            <xsl:if test="@check = 'none exist'">
                <span class="hint">
                    <xsl:text> (check fails if output present)</xsl:text>
                </span>
            </xsl:if>
            <xsl:for-each select="following-sibling::*[1]/out/l" xpath-default-namespace="">
                <!-- [WKM 08.23.2013] Added check for non-empty elements -->
                <xsl:if test="text()">
                    <samp>
                        <xsl:value-of select="."/>
                    </samp>
                </xsl:if>
            </xsl:for-each>
            <xsl:if test="../check:outcome = 'error'">
                <br/>
                <span class="hint">
                    <xsl:text> (an error occurred)</xsl:text>
                </span>
                <xsl:for-each select="following-sibling::*[1]/err/l" xpath-default-namespace="">
                    <!-- [WKM 08.23.2013] Added check for non-empty elements -->
                    <xsl:if test="text()">
                        <span class="error">
                            <samp>
                                <xsl:value-of select="."/>
                            </samp>
                        </span>
                    </xsl:if>
                </xsl:for-each>
            </xsl:if>
        </div>
        <script type="text/javascript">
            <xsl:text>setState('</xsl:text>
            <xsl:value-of select="generate-id()"/>
            <xsl:text>_xml', false);</xsl:text>
        </script>
    </xsl:template>
    <xsl:template mode="check" match="file-content" xpath-default-namespace="http://cisecurity.org/check">
        <code class="path">
            <xsl:value-of select="path"/>
        </code>
        <xsl:if test="@check = 'all'">
            <span class="hint">
                <xsl:text> (check fails if no output present)</xsl:text>
            </span>
        </xsl:if>
        <xsl:if test="@check = 'none exist'">
            <span class="hint">
                <xsl:text> (check fails if output present)</xsl:text>
            </span>
        </xsl:if>
        <xsl:for-each select="following-sibling::result/l" xpath-default-namespace="">
            <samp>
                <xsl:value-of select="."/>
            </samp>
        </xsl:for-each>
    </xsl:template>
    <xsl:template mode="check" match="msw-registry" xpath-default-namespace="http://cisecurity.org/check">
        <code class="registry_key">
            <span>
                <xsl:attribute name="title">
                    <xsl:value-of select="following-sibling::result/@type" xpath-default-namespace=""/>
                </xsl:attribute>
                <xsl:value-of select="string-join( (hive,key,name) , '\' )"/>
            </span>
        </code>
        <xsl:call-template name="format-value"/>
        <samp class="registry_key">
            <xsl:value-of select="following-sibling::result/@type" xpath-default-namespace=""/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="following-sibling::result/text()" xpath-default-namespace=""/>
        </samp>
        <xsl:if test="following-sibling::result/@error" xpath-default-namespace="">
            <br/>
            <samp class="error">
                <xsl:value-of select="following-sibling::result/@error"/>
            </samp>
        </xsl:if>
    </xsl:template>
    <xsl:template name="format-value" xpath-default-namespace="http://cisecurity.org/check">
        <xsl:choose>
            <xsl:when test="value">
                <xsl:text> </xsl:text>
                <xsl:value-of select="fn:op-char(if (value/@op) then value/@op else '?')"/>
                <xsl:text> </xsl:text>
                <xsl:choose>
                    <xsl:when test="value/@value">
                        <xsl:value-of select="fn:guillemet(value/@value)"/>
                    </xsl:when>
                    <xsl:when test="value/@value-id">
                        <xsl:value-of select="//xccdf:set-value[ @idref = current()/value/@value-id ]"/>
                        <span title="XCCDF Value">
                            <xsl:text> {</xsl:text>
                            <xsl:value-of select="value/@value-id"/>
                            <xsl:text>}</xsl:text>
                        </span>
                    </xsl:when>
                    <xsl:otherwise/>
                </xsl:choose>
                <xsl:if test="value/@dt">
                    <xsl:text> cast as </xsl:text>
                    <xsl:value-of select="value/@dt"/>
                </xsl:if>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="format-value-attr" xpath-default-namespace="http://cisecurity.org/check">
        <xsl:if test="@op">
            <xsl:text> </xsl:text>
            <xsl:value-of select="fn:op-char(if (@op) then @op else '?')"/>
            <xsl:text> </xsl:text>
            <xsl:choose>
                <xsl:when test="@value">
                    <xsl:value-of select="fn:guillemet(@value)"/>
                </xsl:when>
                <xsl:when test="@value-id">
                    <xsl:value-of select="fn:guillemet(//xccdf:set-value[ @idref = current()/@value-id ])"/>
                    <span title="XCCDF Value">
                        <xsl:text> {</xsl:text>
                        <xsl:value-of select="@value-id"/>
                        <xsl:text>}</xsl:text>
                    </span>
                </xsl:when>
                <xsl:otherwise/>
            </xsl:choose>
            <xsl:if test="@dt">
                <xsl:text> cast as </xsl:text>
                <xsl:value-of select="@dt"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    <xsl:template mode="check" match="SQL-query" xpath-default-namespace="http://cisecurity.org/check">
        <code class="SQL">
            <xsl:value-of select="query"/>
        </code>
        <xsl:if test=" @check = 'none exist' ">
            <span class="hint" title="returns no rows">
                <xsl:text> = ∅</xsl:text>
            </span>
        </xsl:if>
        <xsl:if test=" @check = 'at least one' ">
            <span class="hint" title="returns rows">
                <xsl:text> ≠ ∅</xsl:text>
            </span>
        </xsl:if>
        <xsl:if test="following-sibling::result/rs/@comment" xpath-default-namespace="">
            <br/>
            <span class="hint">
                <xsl:text> (</xsl:text>
                <xsl:value-of select="following-sibling::result/rs/@comment"/>
                <xsl:text>)</xsl:text>
            </span>
        </xsl:if>
        <xsl:if test="following-sibling::result/@error" xpath-default-namespace="">
            <br/>
            <samp class="error">
                <xsl:value-of select="following-sibling::result/@error"/>
            </samp>
        </xsl:if>
        <xsl:if test="following-sibling::result/rs/r" xpath-default-namespace="">
            <table class="result">
                <thead>
                    <tr>
                        <xsl:for-each select="following-sibling::result/rs/r[1]/c" xpath-default-namespace="">
                            <th>
                                <xsl:value-of select="@name"/>
                            </th>
                        </xsl:for-each>
                    </tr>
                </thead>
                <tbody>
                    <xsl:for-each select="following-sibling::result/rs/r" xpath-default-namespace="">
                        <tr>
                            <xsl:for-each select="c">
                                <td>
                                    <xsl:value-of select="."/>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </xsl:for-each>
                </tbody>
            </table>
        </xsl:if>
    </xsl:template>
    <xsl:template mode="check" match="oracle-parameter" xpath-default-namespace="http://cisecurity.org/check">
        <code class="oracle-parameter">
            <xsl:value-of select="name"/>
            <xsl:call-template name="format-value"/>
        </code>
        <xsl:choose>
            <xsl:when test=" following-sibling::result/@error " xpath-default-namespace="">
                <samp class="error">
                    <xsl:value-of select="following-sibling::result/@error"/>
                </samp>
            </xsl:when>
            <xsl:when test=" not(value) or following-sibling::check:outcome = 'fail' ">
                <samp>
                    <xsl:value-of select="following-sibling::result/parameter/@name" xpath-default-namespace=""/>
                    <xsl:text> = </xsl:text>
                    <xsl:value-of select="following-sibling::result/parameter/@value" xpath-default-namespace=""/>
                </samp>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template mode="evaluate" match="*:Win32_RegistryValue">
        <span class="registry_key">
            <xsl:value-of select="string-join( (@hive,@key,@name) , '\' )"/>
        </span>
    </xsl:template>
    <xsl:template mode="evaluate" match="*">
        <code>
            <xsl:text>&lt;</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:for-each select="@*">
                <xsl:text> </xsl:text>
                <xsl:value-of select="name()"/>
                <xsl:text>="</xsl:text>
                <xsl:value-of select="."/>
                <xsl:text>"</xsl:text>
            </xsl:for-each>
            <xsl:text>/&gt;</xsl:text>
        </code>
    </xsl:template>

    <xsl:template mode="result" match="*">
        <xsl:choose>
            <xsl:when test="@error">
                <br/>
                <samp class="error">
                    <xsl:value-of select="@error"/>
                </samp>
            </xsl:when>
            <xsl:when test="@notfound">
                <br/>
                <samp class="error">
                    <xsl:value-of select="@notfound"/>
                </samp>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="text()">
                    <br/>
                    <samp>
                        <xsl:text> = «</xsl:text>
                        <xsl:value-of select="text()" xpath-default-namespace=""/>
                        <xsl:text>»</xsl:text>
                    </samp>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="node()" mode="check">
        <xsl:value-of select="following-sibling::*:message"/>
    </xsl:template>

    <xsl:template match="element()" mode="xhtml">
        <xsl:element name="{local-name()}" namespace="http://www.w3.org/1999/xhtml">
            <xsl:apply-templates mode="xhtml" select="attribute()|element()|text()|comment()"/>
        </xsl:element>
    </xsl:template>
    <!-- @@:WKM 01.11.2013 - Start:  Handle text nodes a bit differently to account for DISA benchmarks which    -->
    <!--                             contain some "random-esque" tags in their group/rule descriptions.  Display -->
    <!--                             the tags which have data as the Tag name in bold, followed by its text...   -->
    <xsl:template match="text()" mode="xhtml">
        <xsl:analyze-string select="." regex="&lt;(\w+)?&gt;([^&lt;]+?)&lt;/\w+?&gt;">
            <xsl:matching-substring>
                <!-- These are the tags with data between them... -->
                <b>
                    <xsl:value-of select="concat(regex-group(1),':')"/>
                </b>
                <p>
                    <xsl:value-of select="regex-group(2)"/>
                </p>
            </xsl:matching-substring>
            <xsl:non-matching-substring>
                <!-- Either empty tags or well-formatted XHTML tags (as in the CIS benchmarks) fall to the non-matching -->
                <!-- substring.  If its an empty DISA tag, ignore it.  If its a well-formatted XHTML tag, pass it on... -->
                <xsl:analyze-string select="." regex="&lt;(\w+)?&gt;&lt;/\w+?&gt;">
                    <xsl:matching-substring/>
                    <xsl:non-matching-substring>
                        <xsl:value-of select="."/>
                    </xsl:non-matching-substring>
                </xsl:analyze-string>
            </xsl:non-matching-substring>
        </xsl:analyze-string>
    </xsl:template>
    <!-- @@:WKM 01.11.2013 - END -->
    <xsl:template match="attribute()|comment()" mode="xhtml">
        <xsl:copy/>
    </xsl:template>

    <!--<xsl:template match="evidence_ecl" xpath-default-namespace="http://benchmarks.cisecurity.org/evidence/1.0">
        <xsl:apply-templates select="xccdf:check-content"/>
    </xsl:template>-->

    <!-- TEMPORARY -->
    <!--<xsl:template match="*:check-content-ref"> </xsl:template>
    <xsl:template match="*:check-export"> </xsl:template>
    <xsl:template match="*:check"> </xsl:template>

    <xsl:template match="metadata" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <p>
            <xsl:apply-templates select="cis:evidence" mode="EVIDENCE"/>
        </p>
    </xsl:template>-->

    <!-- Unmatched Nodes... -->
    <xsl:template match="*">
        <xsl:message select="."/>
        <!--<xsl:message terminate="yes" select="'unmatched node'"/>-->
    </xsl:template>
</xsl:transform>
