<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" 
    xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2" 
    xmlns:scap-con="http://scap.nist.gov/schema/scap/constructs/1.2" xmlns:xccdf="http://checklists.nist.gov/xccdf/1.2" xmlns:arf="http://scap.nist.gov/schema/asset-reporting-format/1.1" xmlns:dsc="http://scap.nist.gov/schema/scap/source/1.2" xmlns:ai="http://scap.nist.gov/schema/asset-identification/1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="#all" xmlns:functx="http://www.functx.com">
    <!-- transform to create benchmark report -->
    <!-- Copyright © 2008 - Center for Internet Security. -->
    <!-- CONFIDENTIAL & PROPRIETARY -->
    <xsl:strip-space elements="*"/>
    
    <xsl:output method="text" encoding="UTF-8"/>
    <xsl:param name="debugging" as="xs:boolean" required="no" select="false()"/>
    <xsl:param name="includeUncheckedItems" as="xs:boolean" select="true()" />
    
    <xsl:variable name="selected_benchmark_id" select="/arf:asset-report-collection/arf:reports/arf:report/arf:content/xccdf:TestResult/xccdf:benchmark/@id"/>
    <xsl:variable name="selected_benchmark" as="node()" select="/arf:asset-report-collection/arf:report-requests/arf:report-request/arf:content/dsc:data-stream-collection/dsc:component/xccdf:Benchmark[ @id = $selected_benchmark_id ]"/>
    <xsl:variable name="TestResult" as="node()" select="/arf:asset-report-collection/arf:reports/arf:report/arf:content/xccdf:TestResult"/>
    
    <xsl:variable name="hide-unchecked-items" as="xs:boolean"
        select="matches(processing-instruction('CIS-CAT'),'hide-unchecked-items=.true.')"/>
    
    <xsl:template match="/" xpath-default-namespace="http://scap.nist.gov/schema/asset-reporting-format/1.1">
        <xsl:apply-templates select="$selected_benchmark"/>
    </xsl:template>
    
    <xsl:template match="Benchmark" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:apply-templates select="/arf:asset-report-collection/arf:reports/arf:report/arf:content/xccdf:TestResult"/>
        <xsl:apply-templates select="xccdf:Group|xccdf:Rule"/>
        
        <!--<xsl:variable name="TestResult" select="/arf:asset-report-collection/arf:reports/arf:report/arf:content/xccdf:TestResult"/>-->
        
        <xsl:text>********** Total **********</xsl:text>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>Pass: </xsl:text>
        <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('pass','fixed') ] )"/>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>Fail: </xsl:text>
        <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('fail') ] )"/>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>Error: </xsl:text>    
        <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('error') ] )"/>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>Unknown: </xsl:text>    
        <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('unknown') ] )"/>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>Not Selected: </xsl:text>
        <xsl:value-of select="count( $TestResult/xccdf:rule-result[ xccdf:result = ('notapplicable', 'notchecked', 'informational', 'notselected') ] )" />
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:variable name="s2">
            <xsl:call-template name="score-flat-weighted"/>
        </xsl:variable>
        <xsl:text>Actual Pass: </xsl:text>            
        <xsl:value-of select="format-number($s2/*/@value,'0.0')"/>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>Maximum Possible: </xsl:text>
        <xsl:value-of select="format-number($s2/*/@weight,'0.0')"/>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>Score: </xsl:text> 
        <xsl:variable name="p" select="$s2/*/@value"/>
        <xsl:variable name="t" select="$s2/*/@weight"/>
        <xsl:variable name="s" select="if ($t = 0) then 0 else $p div $t"/>
        <xsl:value-of select="format-number($s*100,'##0')"/>
        <xsl:text>%</xsl:text>
    </xsl:template>
    
    <xsl:template match="TestResult" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        
        <xsl:variable name="duration" select="xs:dateTime($TestResult/@end-time) - xs:dateTime($TestResult/@start-time)" />
        <xsl:variable name="durationMinutes" select="round(minutes-from-duration($duration))" />
        <xsl:variable name="durationSeconds" select="round(seconds-from-duration($duration))" />
        
        <xsl:value-of select="title"/>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>Evaluation of: </xsl:text>
        <xsl:value-of select="target"/>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <!--<xsl:text>Began: </xsl:text>
        <xsl:value-of select="@start-time"/>
        <xsl:text>&#x0a;</xsl:text>-->
        <xsl:text>Ended: </xsl:text>
        <xsl:value-of select="@end-time"/>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>Assessment Duration: </xsl:text>
        <xsl:choose>
            <xsl:when test="$durationMinutes &gt; 1">
                <xsl:value-of select="$durationMinutes"/>
                <xsl:text> minutes, </xsl:text>
            </xsl:when>
            <xsl:when test="$durationMinutes = 1">
                <xsl:value-of select="$durationMinutes"/>
                <xsl:text> minute, </xsl:text>
            </xsl:when>
        </xsl:choose>
        <xsl:value-of select="$durationSeconds"/>
        <xsl:text> seconds</xsl:text>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
        <xsl:text>&#x0d;&#x0a;</xsl:text>
    </xsl:template>
    
    <xsl:template match="Group" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:apply-templates select="xccdf:Group|xccdf:Rule"/>
    </xsl:template>
    
    <xsl:template match="Rule" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:variable name="section">
            <xsl:number count="xccdf:Group|xccdf:Rule" level="multiple"/>
        </xsl:variable>
        <xsl:variable name="the_rule" select="."/>
        <xsl:variable name="result" select="$TestResult/xccdf:rule-result[ @idref = current()/@id ]"/>
        
        <xsl:for-each select="$result">
            <xsl:if test="(($includeUncheckedItems = true()) and xccdf:result != 'notselected' and xccdf:result != 'notapplicable') or ($includeUncheckedItems = false() and xccdf:result != 'notselected' and xccdf:result != 'notchecked')">
                <xsl:choose>
                    <xsl:when test="xccdf:result = ('informational','notchecked')">
                        <xsl:text>manual</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="xccdf:result"/>
                    </xsl:otherwise>
                </xsl:choose>
                <!--<xsl:choose>
                    <xsl:when test=" matches(result,'pass|fail|notselected|error|notchecked') "> </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>????</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>-->
                <xsl:text>: </xsl:text>
                <xsl:value-of select="$section"/>
                <xsl:text>&#x20;</xsl:text>
                <xsl:if test="$the_rule/xccdf:title">
                    <xsl:value-of select="fn:replace($the_rule/xccdf:title[1], '\n\s+', ' ')"/>
                </xsl:if>         
                <xsl:text>&#x0d;&#x0a;</xsl:text>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="score-flat-weighted" xpath-default-namespace="http://checklists.nist.gov/xccdf/1.2">
        <xsl:choose>
            <xsl:when test="local-name() = 'Rule'">
                <xsl:variable name="weight" select="if (@weight) then @weight else 1" />
                <xsl:variable name="rule-result" select="$TestResult/xccdf:rule-result[@idref=current()/@id]"/>
                <xsl:for-each select="$rule-result">
                    <xsl:choose>
                        <xsl:when test="matches(xccdf:result,'pass|fixed')">
                            <score value="{1 * $weight}" weight="{$weight}"/>
                        </xsl:when>
                        <xsl:when test="matches(xccdf:result,'fail|error|unknown')">
                            <score value="0" weight="{$weight}"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <score value="0" weight="0"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="matches(local-name(),'Benchmark|Group')">
                <xsl:variable name="scores">
                    <xsl:for-each select="xccdf:Group|xccdf:Rule">
                        <xsl:call-template name="score-flat-weighted"/>
                    </xsl:for-each>
                </xsl:variable>
                <score value="{sum($scores/*/@value)}" weight="{sum($scores/*/@weight)}"/>
            </xsl:when>
            <xsl:otherwise>
                <score value="0" weight="0"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:transform>
