Function Get-SerialPort {
    Param (
        [Parameter(Mandatory=$True,ValueFromPipeline=$True,ValueFromPipelinebyPropertyName=$True)]
        $VM
    )
    Process {
        Foreach ($VMachine in $VM) {
            Foreach ($Device in $VMachine.ExtensionData.Config.Hardware.Device) {
                If ($Device.gettype().Name -eq "VirtualSerialPort"){
                    $Details = New-Object PsObject
                    $Details | Add-Member Noteproperty VM -Value $VMachine
                    $Details | Add-Member Noteproperty Name -Value $Device.DeviceInfo.Label
                    $Details | Add-Member Noteproperty Connected -Value $Device.Connectable.Connected
                    $Details | Add-Member Noteproperty StartConnected -Value $Device.Connectable.StartConnected
                    $Details | Add-Member Noteproperty GuestConnected -Value $Device.Connectable.AllowGuestControl
                    $Details
                }
            }
        }
    }
}

Function Get-ParallelPort {
    Param (
        [Parameter(Mandatory=$True,ValueFromPipeline=$True,ValueFromPipelinebyPropertyName=$True)]
        $VM
    )
    Process {
        Foreach ($VMachine in $VM) {
            Foreach ($Device in $VMachine.ExtensionData.Config.Hardware.Device) {
                If ($Device.gettype().Name -eq "VirtualParallelPort"){
                    $Details = New-Object PsObject
                    $Details | Add-Member Noteproperty VM -Value $VMachine
                    $Details | Add-Member Noteproperty Name -Value $Device.DeviceInfo.Label
                    $Details | Add-Member Noteproperty Connected -Value $Device.Connectable.Connected
                    $Details | Add-Member Noteproperty StartConnected -Value $Device.Connectable.StartConnected
                    $Details | Add-Member Noteproperty GuestConnected -Value $Device.Connectable.AllowGuestControl
                    $Details
                }
            }
        }
    }
}

$deviceType=$args[0]
if ("Get-SerialPort" -eq $deviceType) {
    Get-VM | Get-SerialPort | ConvertTo-Csv -NoTypeInformation
}
if ("Get-ParallelPort" -eq $deviceType) {
    Get-VM | Get-ParallelPort | ConvertTo-Csv -NoTypeInformation
}
if ("Get-FloppyDrive" -eq $deviceType) {
    Get-VM | Get-FloppyDrive | Select Parent, Name, ConnectionState | ConvertTo-Csv -NoTypeInformation
}
if ("Get-CDDrive" -eq $deviceType) {
    Get-VM | Get-CDDrive | Select Parent, Name, ConnectionState | ConvertTo-Csv -NoTypeInformation
}
if ("Get-USBDevice" -eq $deviceType) {
    Get-VM | Get-USBDevice | Select Parent, Name, ConnectionState | ConvertTo-Csv -NoTypeInformation
}
if ("Get-HardDisk" -eq $deviceType) {
    Get-VM | Get-HardDisk | Select Parent, Name, ConnectionState | ConvertTo-Csv -NoTypeInformation
}