# I think we always need the "Value" of the advanced setting so the command in that case would be:
# "Get-VMHost | Get-AdvancedSetting -Name ${advancedSetting} | Select Value | ConvertTo-Csv -NoTypeInformation"

$advancedSetting=$args[0]
$vmHostName=$args[1]
$Output =
    Get-VMHost | Get-AdvancedSetting -Name $advancedSetting | Select @{N="$vmHostName";E={$_.Entity}}, Name, Value
$Output | ConvertTo-Csv -NoTypeInformation