# List the services which are enabled and do not have rules defined for specific IP ranges to access the service
$Output =
    Foreach ($VMHost in Get-VMHost ) {
        Get-VMHost $VMHost | Get-VMHostFirewallException | Where {$_.Enabled -and ($_.ExtensionData.AllowedHosts.AllIP)} | Select @{N="VMHost";E={$VMHost}}, Name, IncomingPorts, OutgoingPorts, Protocols, ServiceRunning
    }
$Output | ConvertTo-Csv -NoTypeInformation