$Output =
        Foreach ($VMHost in Get-VMHost ) {
            $ESXCli = Get-EsxCli -V2 -VMHost $VMHost
            $vibDtls = $ESXCli.software.vib.list.Invoke()
            Foreach ($vibDtl in $vibDtls ) {
                $Details = New-Object PsObject
                $Details | Add-Member Noteproperty VMHost -Value $VMHost
                $Details | Add-Member Noteproperty AcceptanceLevel -Value $vibDtl.AcceptanceLevel
                $Details | Add-Member Noteproperty CreationDate -Value $vibDtl.CreationDate
                $Details | Add-Member Noteproperty ID -Value $vibDtl.ID
                $Details | Add-Member Noteproperty InstallDate -Value $vibDtl.InstallDate
                $Details | Add-Member Noteproperty Name -Value $vibDtl.Name
                $Details | Add-Member Noteproperty Status -Value $vibDtl.Status
                $Details | Add-Member Noteproperty Vendor -Value $vibDtl.Vendor
                $Details | Add-Member Noteproperty Version -Value $vibDtl.Version
                $Details
            }
        }
$Output | ConvertTo-Csv -NoTypeInformation